% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invictor.R
\name{insiders}
\alias{insiders}
\alias{\%[]\%}
\alias{\%()\%}
\alias{\%[)\%}
\alias{\%(]\%}
\alias{\%[.]\%}
\alias{\%(.)\%}
\alias{\%[.)\%}
\alias{\%(.]\%}
\title{Inside interval}
\usage{
x \%[]\% j

x \%()\% j

x \%[)\% j

x \%(]\% j

x \%[.]\% j

x \%(.)\% j

x \%[.)\% j

x \%(.]\% j
}
\arguments{
\item{x}{A vector}

\item{j}{A 2-element numeric vector indicating a range}
}
\value{
Logical vector of length \code{x}, or, values in the range \code{j}
}
\description{
Decide if a value \code{x} falls inside an interval \code{j[1],j[2]} that can be open or closed on the left and/or the right. Either a logical vector equal to \code{x}, or the actual values are extracted, when the `.`-versions are used.
}
\note{
Package `DescTools` provides similar functions
}
\examples{

# Closed interval
0:5 \%[]\% c(1,5)  # logical vector
0:5 \%[.]\% c(1,5) # extract values

# Open interval
0:5 \%()\% c(1,5)
0:5 \%(.)\% c(1,5)

# Closed interval left
0:5 \%[)\% c(1,5)
0:5 \%[.)\% c(1,5)

# Closed interval right
0:5 \%(]\% c(1,5)
0:5 \%(.]\% c(1,5)


}
