% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ai.R
\name{aiEst}
\alias{aiEst}
\title{Estimate adverse impact given d and sr}
\usage{
aiEst(d, sr, pct_minority)
}
\arguments{
\item{d}{Subgroup difference.}

\item{sr}{The percentage of the applicant population who are selected.}

\item{pct_minority}{The percentage of the applicant population who are part of
a given minority group.}
}
\value{
(1) The adverse impact ratio, (2) The overall selection ration, (3) 
        The selection ratio for the majority group, (4) The selection ratio
        for the minority group, and (5) the predictor cutoff value that corresponds to 
        the given overall selection ratio
}
\description{
Estimate adverse impact given d and sr
}
\examples{
aiEst(d = 0.15, sr = 0.25, pct_minority = 0.30)

aiEst(d = 0.40, sr = 0.10, pct_minority = 0.15)
}
\author{
Jeff Jones and Allen Goebl
}
\references{
De Corte, W., Lievens, F.(2003). A Practical procedure to estimate
the quality and the adverse impact of single-stage selection decisions.
\emph{International Journal of Selection and Assessment.}, 11(1), 87-95.
}

