/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.toolkit;

import java.awt.Polygon;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.toolkit.PPrimPolygon;
import org.rosuda.pograss.PoGraSS;

public class PPrimHam
extends PPrimPolygon {
    int x1;
    int y1;
    int x2;
    int y2;
    public boolean alwaysAlpha = false;
    public double fudge = 0.2;
    public int total = 0;
    public int tmp = 0;
    public int leftVar = 0;
    int dx;
    int dy;

    public PPrimHam() {
        this.drawBorder = false;
    }

    public void updateAnchors(int n, int n2, int n3, int n4, int n5) {
        this.x1 = n;
        this.y1 = n2;
        this.x2 = n3;
        this.y2 = n4;
        if (this.cases() < 1) {
            return;
        }
        double d = this.x2 - this.x1;
        double d2 = this.y2 - this.y1;
        double d3 = this.cases();
        if (this.total == 0) {
            this.total = this.cases() * 2;
        }
        double d4 = d3 / (double)this.total * (double)n5 * this.fudge * 0.5;
        this.dy = (int)(d4 / Math.sqrt(1.0 + d2 * d2 / (d * d)));
        this.dx = (int)(-(d2 * d4 / Math.sqrt(d * d + d2 * d2)));
        if (this.dy < 1 && this.dx < 1) {
            this.dy = 1;
        }
        int[] nArray = new int[4];
        nArray[0] = this.x1 - this.dx;
        int[] nArray2 = new int[4];
        nArray2[0] = this.y1 - this.dy;
        nArray[1] = this.x2 - this.dx;
        nArray2[1] = this.y2 - this.dy;
        nArray[2] = this.x2 + this.dx;
        nArray2[2] = this.y2 + this.dy;
        nArray[3] = this.x1 + this.dx;
        nArray2[3] = this.y1 + this.dy;
        this.pg = new Polygon(nArray, nArray2, 4);
    }

    public void paint(PoGraSS poGraSS, int n, SMarker sMarker) {
        if (this.cases() > 1) {
            super.paint(poGraSS, n, sMarker);
            return;
        }
        if (this.col != null) {
            poGraSS.setColor(this.col.getRed(), this.col.getGreen(), this.col.getBlue());
        } else {
            poGraSS.setColor("object");
        }
        poGraSS.drawLine(this.x1, this.y1, this.x2, this.y2);
    }

    public void paintSelected(PoGraSS poGraSS, int n, SMarker sMarker) {
        if (this.cases() > 1) {
            int n2;
            int n3 = this.dx > 0 ? this.dx : -this.dx;
            int n4 = n2 = this.dy > 0 ? this.dy : -this.dy;
            if (this.alwaysAlpha || n3 + n2 < 3) {
                super.paintSelected(poGraSS, n, sMarker);
                return;
            }
            double d = this.getMarkedProportion(sMarker, -1);
            Polygon polygon = this.pg;
            int[] nArray = new int[4];
            int n5 = (int)((double)this.dx * (2.0 * d - 1.0));
            int n6 = (int)((double)this.dy * (2.0 * d - 1.0));
            nArray[0] = this.x1 - n5;
            int[] nArray2 = new int[4];
            nArray2[0] = this.y1 - n6;
            nArray[1] = this.x2 - n5;
            nArray2[1] = this.y2 - n6;
            nArray[2] = this.x2 + this.dx;
            nArray2[2] = this.y2 + this.dy;
            nArray[3] = this.x1 + this.dx;
            nArray2[3] = this.y1 + this.dy;
            boolean bl = this.useSelAlpha;
            this.useSelAlpha = false;
            this.pg = new Polygon(nArray, nArray2, 4);
            super.paintSelected(poGraSS, n, sMarker);
            this.pg = polygon;
            this.useSelAlpha = bl;
            return;
        }
        double d = this.getMarkedProportion(sMarker, -1);
        if (d > 0.0) {
            poGraSS.setColor(Common.selectColor);
            poGraSS.drawLine(this.x1, this.y1, this.x2, this.y2);
        }
    }

    public String toString() {
        return "PPrimHam(" + this.x1 + "," + this.y1 + "," + this.x2 + "," + this.y2 + ", cases=" + this.cases() + ", drawBorder=" + this.drawBorder + ")";
    }
}

