% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipwCoxCluster.R
\name{ipwCoxCluster}
\alias{ipwCoxCluster}
\title{Inference of marginal HR in IPW Cox model based on CSV with clustering}
\usage{
ipwCoxCluster(data, indID, indA, indX, indStatus, indTime, ties = "breslow",
  confidence = 0.95)
}
\arguments{
\item{data}{A clustered dataset to be analyzed in the form of R data frame.}

\item{indID}{A column name indicating the cluster variable. Observations from the same cluster have the same indID value.}

\item{indA}{A column name indicating the treatment variable.}

\item{indX}{A vector of column names indicating the covariates included in the propensity score model.}

\item{indStatus}{A column name indicating the non-censoring status (1 if observed and 0 if censored).}

\item{indTime}{A column name indicating the outcome variable, i.e., min(true event time, censoring time).}

\item{ties}{A character string indicating the method ("efron","breslow",or "exact") to deal with tied events for point estimation; the default is "breslow". For variance estimation, Breslow method is used to deal with tied events.}

\item{confidence}{A confidence level between 0 and 1; the default is 0.95 corresponding to a 95 per cent confidence interval.}
}
\value{
A matrix of inference results from inverse probability weighted Cox model with clustered data. The first and the second rows report log marginal hazard ratio estimate and associated corrected sandwich based standard error, marginal hazard ratio estimate and associated normality-based confidence interval, under conventional inverse probability weights and stabilized weights, respectively.
}
\description{
Inference of marginal hazard ratios (HR) in inverse probability weighted (IPW) Cox model with clustered data, under both the conventional inverse probability weights and the stabilized weights. Corrected sandwich variance (CSV) estimation method is used for variance estimation of estimated log marginal hazard ratios.
}
\examples{
#simulate a dataset under marginal hazard ratio 1.5 with clustering
set.seed(100)
n=300
oneGene<-function(id){
 tau=0.7
 alpha=(1/tau-1)/2
 u1=runif(1)
 u2=runif(1)
 af=(1-u2)^(-1/alpha)
 T0v1=-log(1-u2)
 T0v2=alpha*log((1-af)+af*((1-u1)^(-1/(1+alpha))))
 T0=c(T0v1,T0v2)
 ZZZ=rep(rnorm(1),2)
 X1before= 0.5*(T0+0.2)/(T0+1)+0.3*ZZZ
 X1=mean(X1before)
 X2= 1/log(1.3*T0+3)-0.3*ZZZ
 X3= rbinom(2,1,0.3+0.5/(T0+1))  
 A=rbinom(2,1,1/(1+exp(1-2*X1-X2-X3)))
 Ttime <- T0*exp(-log(1.5)*A)
 rateC=0.5
 C <- rexp(2, rate=rateC)
 time <- pmin(Ttime, C)
 status <- as.numeric(Ttime <= C)
 cbind(id=id,time=time,status=status,A=A,X1=X1,X2=X2,X3=X3)
} 
da=as.data.frame(do.call("rbind",lapply(1:n,oneGene)))
head(da)
#inference results for marginal hazard ratio 
ipwCoxCluster(data=da,indID="id",indA="A",indX=c("X1","X2","X3"),indStatus="status",indTime="time")

}
