% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agree.coeff3.raw.r
\name{krippen.alpha.raw}
\alias{krippen.alpha.raw}
\title{Krippendorff's alpha coefficient for an arbitrary number of raters (2, 3, +) when the input data represent the raw ratings reported for each subject and each rater.}
\usage{
krippen.alpha.raw(ratings, weights = "unweighted", categ.labels = NULL,
  conflev = 0.95, N = Inf)
}
\arguments{
\item{ratings}{An nxr matrix / data frame of ratings where each column represents one rater and each row one subject.}

\item{weights}{is a mandatory parameter that is either a string variable or a matrix. 
The string describes one of the predefined weights and must take one of the values 
("quadratic", "ordinal", "linear", "radical", "ratio", "circular", "bipolar"). 
If this parameter is a matrix then it must be a square matri qxq where q is the number 
of posssible categories where a subject can be classified. If some of the q possible 
categories are not used, then it is strobgly advised to specify the complete list of 
possible categories as a vector in parametr categ.labels. Otherwise, the program may not work.}

\item{categ.labels}{An optional vector parameter containing the list of all possible ratings. It may be useful in 
case some of the possibe ratings are not used by any rater, they will still be used when calculating agreement 
coefficients. The default value is NULL. In this case, only categories reported by the raters are used in the
calculations.}

\item{conflev}{An optional parameter representing the confidence level associated with the confidence interval. Its default value is 0.95.}

\item{N}{An optional parameter representing the population size (if any). It may be use to perform the final population correction to the variance.  Its default value is infinity.}
}
\value{
A data list containing 3 objects: (1) a one-row data frame containing various statistics including the 
requested agreement coefficient-in this case, Krippendorff's alpha, (2) the weight matrix used in the calculations if any, and 
(3) the vector of categories used in the analysis. These could be categories reported by the raters, or those that were available 
to the raters whether they used them or not.  The output data frame contains the following variables: "coeff.name" (coefficient 
name), "pa" (the percent agreement), "pe" (the percent chance agreement), coeff.val (Krippendorff's alpha estimate), "coeff.se 
(standard error), conf.int" (Krippendorff alpha's confidence interval),"p.value" (Krippendorff alpha's p-value), "w.name" 
(the weights' identification).
}
\description{
Krippendorff's alpha coefficient for an arbitrary number of raters (2, 3, +) when the input data represent the raw ratings reported for each subject and each rater.
}
\examples{
#The dataset "cac.raw4raters" comes with this package. Analyze it as follows:
cac.raw4raters
krippen.alpha.raw(cac.raw4raters) #Alpha coeff. , precision measures, weights & categories
krippen.alpha.raw(cac.raw4raters)$est #Krippendorff's alpha with precision measures
alpha <- krippen.alpha.raw(cac.raw4raters)$est$coeff.val #Krippendorff's alpha alone.
alpha
krippen.alpha.raw(cac.raw4raters, weights = "quadratic") #weighted alpha/ quadratic wts
}
\references{
Gwet, K. (2014). \emph{Handbook of Inter-Rater Reliability: The Definitive Guide to Measuring the Extent of Agreement Among Multiple Raters}, 4th Edition.  Advanced Analytics, LLC.\cr\cr
Krippendorff (1970). ``Bivariate agreement coefficients for reliability of data." \emph{Sociological Methodology},2,139-150.\cr\cr
Krippendorff (1980). \emph{Content analysis: An introduction to its methodology} (2nd ed.), New-bury Park, CA: Sage.
}
