% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icc1factor.r
\name{ci.ICC1a}
\alias{ci.ICC1a}
\title{Confidence Interval of Intraclass Correlation Coefficient (ICC) under ANOVA Model 1A.}
\usage{
ci.ICC1a(ratings, conflev = 0.95)
}
\arguments{
\item{ratings}{This is a data frame containing 3 columns or more.  The first column contains subject numbers (there could be duplicates
if a subject was assigned multiple ratings) and each of the remaining columns is associated with a particular rater and contains its
numeric ratings.}

\item{conflev}{This is the optional confidence level associated with the confidence interval. If not specified, the default value
will be 0.95, which is the most commonly-used valuee in the literature.}
}
\value{
This function returns a vector containing the lower confidence (lcb) and the upper confidence bound (ucb).
}
\description{
This function computes the lower and upper confidence bounds associated with the ICC under the one-factor ANOVA model
where each subject may be rated by a different group of raters.
}
\examples{
#iccdata3 is a small dataset that comes with the package. Use it as follows:
library(irrICC)
iccdata3 #see what the iccdata3 dataset looks like
ci.ICC1a(iccdata3)
}
\references{
Gwet, K.L. (2014): \emph{Handbook of Inter-Rater Reliability - 4th ed.} chapter 8, section 8.3.1, equations
8.3.1 and 8.3.2. Advanced Analytics, LLC.
}
