% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_single_run.R
\name{sim.single_run}
\alias{sim.single_run}
\title{Run a single isotope box-model simulation}
\usage{
sim.single_run(
  workdir,
  SERIES_ID,
  flux_list,
  coeff_list,
  t_max,
  n_steps,
  isobxr_master_file = "0_ISOBXR_MASTER",
  suppress_messages = FALSE,
  export.diagrams = FALSE,
  export.delta_plot = FALSE,
  export.data_as_csv_xlsx = FALSE,
  plot.time_as_log10 = TRUE,
  plot.time_unit = NULL,
  show.delta_plot = TRUE,
  inspect_inputs = TRUE,
  save_outputs = FALSE,
  return_data = FALSE,
  solver = "auto",
  n_zeros_RUN_IDs = 4,
  FORCING_RAYLEIGH = NULL,
  FORCING_SIZE = NULL,
  FORCING_DELTA = NULL,
  FORCING_ALPHA = NULL,
  COMPOSITE = FALSE,
  COMPO_SERIES_n = NaN,
  COMPO_SERIES_FAMILY = NaN,
  EXPLORER = FALSE,
  EXPLO_SERIES_n = NaN,
  EXPLO_SERIES_FAMILY = NaN,
  isobxr_master = NULL,
  diagram_pdf.widh_height = NULL
)
}
\arguments{
\item{workdir}{Working directory of \strong{\emph{isobxr excel master file}}
and where output files will be stored if exported by user.
(character string)}

\item{SERIES_ID}{Name of the series the run belongs to. \cr
It determines the folder in which the output files will be stored inside workdir.\cr
(character string)}

\item{flux_list}{Name of the list of fluxes and initial box sizes to be used for the run, \cr
calling (by its header name) a single column of the \strong{FLUXES} sheet
of the \strong{\emph{isobxr excel master file}}. \cr
(character string)}

\item{coeff_list}{Name of the list of fractionation coefficients to be used for the run, \cr
calling (by its header name) a single column of the \strong{COEFFS} sheet
of the \strong{\emph{isobxr excel master file}}. \cr
(character string)}

\item{t_max}{Run duration, given in the same time units as unit declared in \strong{CONSTANTS} \cr
spreadsheet of \strong{\emph{isobxr excel master file}} in the \strong{TIME_UNIT} column.
(integer)}

\item{n_steps}{Number of calculation steps. \cr
It determines the resolution of the run. \cr
(integer)}

\item{isobxr_master_file}{Name of \strong{\emph{isobxr excel master file}}. \cr
Default is "0_ISOBXR_MASTER".}

\item{suppress_messages}{If TRUE, hides all information and warning messages regarding run. \cr
Default is FALSE.}

\item{export.diagrams}{If TRUE, exports box-model flux and fractionation diagrams as pdf. \cr
Default is FALSE.}

\item{export.delta_plot}{If TRUE, exports delta and size time evolution plots of the evolution
of the system, as pdf. \cr
Default is FALSE.}

\item{export.data_as_csv_xlsx}{If TRUE, exports all results and run conditions as csv and xlsx files, \cr
to DIGEST directory. \cr
Default is FALSE.}

\item{plot.time_as_log10}{If TRUE, uses logarithmic time scale in plot. \cr
Default is FALSE.}

\item{plot.time_unit}{Time unit to use on plot if different from native time unit. \cr
Character string, to be selected among the following:\cr
\emph{micros, ms, s, min, h, d, wk, mo, yr, kyr, Myr, Gyr}\cr
Default is NULL.}

\item{show.delta_plot}{If TRUE, prints delta and size time evolution plots in R.
Default is TRUE.}

\item{inspect_inputs}{If TRUE, inspects and proof checks format of input taken from
\strong{\emph{isobxr excel master file}}. \cr
(Inspection run by \code{\link{read.isobxr_master}} function.) \cr
Default is TRUE.}

\item{save_outputs}{If TRUE, saves all run outputs to local working directory (workdir). \cr
By default, run outputs are stored in a temporary directory and erased if not saved. \cr
Default is FALSE.}

\item{return_data}{If TRUE, returns all data (inputs and outputs) as a list. \cr
Default is FALSE.}

\item{solver}{Determines what solver to used: "analytical" or "numerical". \cr
Default is "auto" for automatic selection of adapted solver.
Note that this option returns warnings or prevents user to run when solver wished is
not adapted to system solution.}

\item{n_zeros_RUN_IDs}{Number of figures used in iteration of RUNs of a given series (SERIES_ID). \cr
Default is 4: the run IDs of a given series range between 0001 and 9999.}

\item{FORCING_RAYLEIGH}{\emph{OPTIONAL} \cr
Dataframe describing the forcing on a fractionation coefficient
by a Rayleigh isotope distillation, \cr
as a function of flux intensities and a fundamental fractionation coefficient. \cr
Dataframe formatting details are in isobxr vignette. \cr
Default is NULL.}

\item{FORCING_SIZE}{\emph{OPTIONAL} \cr
Dataframe describing the forcing on one or several box sizes (mass of element X). \cr
The newly defined sizes for the given set of boxes
overwrite their sizes as previously defined in \strong{\emph{isobxr excel master file}}. \cr
Dataframe formatting details are in isobxr vignette. \cr
Default is NULL.}

\item{FORCING_DELTA}{\emph{OPTIONAL} \cr
Dataframe describing the forcing on one or several boxes
initial isotope composition expressed as delta values. \cr
The newly defined delta values for the given set of boxes
overwrite the delta values as previously defined in \strong{\emph{isobxr excel master file}}. \cr
Dataframe formatting details are in isobxr vignette. \cr
Default is NULL.}

\item{FORCING_ALPHA}{\emph{OPTIONAL} \cr
Dataframe describing the forcing on one or several
fractionation coefficients from one reservoir to another. \cr
The newly defined alpha values for the given set of boxes
overwrite the alpha values as previously defined in \strong{\emph{isobxr excel master file}}. \cr
Dataframe formatting details are in isobxr vignette. \cr
Default is NULL.}

\item{COMPOSITE}{\emph{NOT TO BE USED IN SINGLE RUN}  \cr
Logical value automatically defined in \code{\link{sim.scenario}}. \cr
Default is FALSE.}

\item{COMPO_SERIES_n}{\emph{NOT TO BE USED IN SINGLE RUN}  \cr
Iteration of the composite run for the given series it belongs to,
automatically defined in \code{\link{sim.scenario}}.  \cr
Default is NaN.}

\item{COMPO_SERIES_FAMILY}{\emph{NOT TO BE USED IN SINGLE RUN} \cr
Composite run series family, automatically defined in
\code{\link{sim.scenario}}. \cr
Default is NaN.}

\item{EXPLORER}{\emph{NOT TO BE USED IN SINGLE RUN} \cr
Logical value automatically defined in \code{\link{sweep.final_nD}}
or \code{\link{sweep.dyn_2D}}. \cr
Default is FALSE.}

\item{EXPLO_SERIES_n}{\emph{NOT TO BE USED IN SINGLE RUN}  \cr
Iteration of the sweep run for the given series it belongs to,
automatically defined in \code{\link{sweep.final_nD}} or \code{\link{sweep.dyn_2D}}. \cr
Default is NaN.}

\item{EXPLO_SERIES_FAMILY}{\emph{NOT TO BE USED IN SINGLE RUN}  \cr
Sweep run series family, automatically defined in
\code{\link{sweep.final_nD}} or \code{\link{sweep.dyn_2D}}. \cr
Default is NaN.}

\item{isobxr_master}{isobxr_master list of input dataframes formatted by
\code{\link{read.isobxr_master}} \cr
Overwrites isobxr_master_file.
Default is NULL.}

\item{diagram_pdf.widh_height}{Vector of width and height in inches of the pdf diagrams.}
}
\value{
A results data set as a list containing the following components:
\enumerate{
\item \strong{inputs} input data:
\enumerate{
\item \strong{CONSTS} data frame of all run specific constants.
\item \strong{INITIAL} data frame of delta and sizes at t = 0 in all boxes.
\item \strong{FLUXES} data frame of all fluxes intensities (row ID: FROM / col ID: TO)
\item \strong{COEFFS} data frame of all fractionation coefficient values (row ID: FROM / col ID: TO)
\item \strong{BOX_META} data frame of box specific metadata (e.g., flux balance, residence times, layout position )
\item \strong{bx.groups} list of box names grouped by relevant categories (e.g., disconnected boxes, infinite boxes)
\item \strong{LOG} data frame of run specific LOG excerpt.
}
\item \strong{outputs} output data:
\enumerate{
\item \strong{solver}
\item \strong{final_state}
\item \strong{delta_vs_t}
\item \strong{size_vs_t}
\item \strong{for analytical solutions}
\enumerate{
\item \strong{diffeq_solutions} solutions of differential equations, \cr
including relaxation times, eigenvalues, constants, eigenvectors
}
}
\item \strong{paths} list of run specific paths

}
}
\description{
A function to run the isobxr stable isotope box model,
assessing the design of the model and automatically running \code{\link{solve_numerically}}
or \code{\link{solve_analytically}} depending on system design.
}
\examples{
\dontrun{
sim.single_run(workdir = "/Users/username/Documents/1_ABC_tutorial",
               SERIES_ID = "1_ABC_balanced_closed",
               flux_list = "Fx1_ABC_bal",
               coeff_list = "a1",
               t_max = 2500,
               n_steps = 2500)
}
}
