% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sweep_dyn_2D.R
\name{sweep.dyn_2D}
\alias{sweep.dyn_2D}
\title{Sweep the space of two parameters during the response to a perturbation}
\usage{
sweep.dyn_2D(
  workdir,
  SERIES_ID,
  plot.time_unit = NULL,
  isobxr_master_file = "0_ISOBXR_MASTER",
  sweep_master_file,
  swept_param_1,
  swept_param_2,
  export.data_as_csv_xlsx = TRUE,
  show.delta_plot = TRUE,
  save_outputs = FALSE,
  ask_confirmation = TRUE,
  keep_single_run_rds = FALSE
)
}
\arguments{
\item{workdir}{Working directory of \strong{\emph{0_ISOBXR_MASTER.xlsx}} master file, \cr
of the dynamic sweep master file (e.g., \strong{\emph{0_EXPLO_DYN_MASTER.xlsx}}) \cr
and where output files will be stored if saved by user. \cr
(character string)}

\item{SERIES_ID}{Name of the sweep series belongs to. \cr
It determines the folder in which the output files will be stored inside workdir.\cr
(character string)}

\item{plot.time_unit}{Time unit to use on plot if different from native time unit. \cr
Character string, to be selected among the following:\cr
\emph{micros, ms, s, min, h, d, wk, mo, yr, kyr, Myr, Gyr}\cr
Default is NULL.}

\item{isobxr_master_file}{Name of \strong{\emph{isobxr excel master file}}. \cr
Default is "0_ISOBXR_MASTER".}

\item{sweep_master_file}{Name of \strong{\emph{sweep.dyn_2D excel master file}}.
(without file "xlsx" extension).}

\item{swept_param_1}{Set of values of sweeping parameter 1. \cr
Formatted data frame, see vignette for further details.}

\item{swept_param_2}{Set of values of sweeping parameter 2. \cr
Formatted data frame, see vignette for further details.}

\item{export.data_as_csv_xlsx}{If TRUE, exports full sweep result data as csv and xlsx fo full
to sweep digest directory. \cr
Default is TRUE.}

\item{show.delta_plot}{If TRUE, prints delta and size time evolution plots in R. \cr
Default is TRUE.}

\item{save_outputs}{If TRUE, saves all run outputs to local working directory (workdir). \cr
By default, run outputs are stored in a temporary directory and erased if not saved. \cr
Default is FALSE.}

\item{ask_confirmation}{If TRUE, asks confirmation to run in interactive sessions. \cr
Default is TRUE.}

\item{keep_single_run_rds}{If TRUE, keeps single runs outputs (rds files in SERIES directory). \cr
Default is FALSE.}
}
\value{
Delta values and box sizes as a function of time in response to a perturbation,
in a 2D space of parameters
sweep.dyn_2D outputs are saved to workdir if save_outputs = TRUE.
}
\description{
A function to assess the influence of two parameters (varying
over a range of values) on dynamic evolution of a system in response to a given perturbation.
}
\section{sweep.dyn_2D outputs consist of}{

\enumerate{
\item \strong{single run results} in SERIES directory: all single runs results as rds files \cr
(keep_single_run_rds = TRUE)
\item \strong{sweep digest} in sweep DIGEST directory (SERIES/DIGEST):
\enumerate{
\item \strong{isobxr master file archive} as xlsx (export.data_as_csv_xlsx = TRUE)
\item \strong{sweep.dyn_2D master file archive} as xlsx (export.data_as_csv_xlsx = TRUE)
\item \strong{sweep.dyn_2D LOG excerpt} as csv (export.data_as_csv_xlsx = TRUE)
\item \strong{delta_size_vs_t} csv of delta and size vs time in 2D space (export.data_as_csv_xlsx = TRUE)
\item \strong{plot of delta and size vs. time in 2D space} as pdf
\item \strong{sweep.dyn_2D results data set} as rds, containing:
\enumerate{
\item \strong{delta_size_vs_t} data frame of delta and size as a function of time
\item \strong{sweeep_master} list containing all inputs from sweep master file
\item \strong{sweep_log} data frame of sweep specific LOG excerpt
\item \strong{isobxr_master} list containing all inputs from isobxr master file
\item \strong{paths} list of sweep specific paths
}
}
}
}

\examples{
\dontrun{
sweep.dyn_2D(workdir = "/Users/username/Documents/1_ABC_tutorial",
             SERIES_ID = "sweep_dyn_test",
             isobxr_master_file = "0_ISOBXR_MASTER",
             sweep_master_file = "0_SWEEP_DYN_demo",
             swept_param_1 = data.frame(FROM = c("A"),
                                        TO = c("C"),
                                        ALPHA_MIN = 0.999,
                                        ALPHA_MAX = 1,
                                        ALPHA_STEPS = 0.0005,
                                        EXPLO_TYPES = "EXPLO_1_ALPHA"),
             swept_param_2 = data.frame(BOX_ID = c("B"),
                                        SIZE_MIN = 2100,
                                        SIZE_MAX = 3000,
                                        SIZE_STEPS = 300,
                                        EXPLO_TYPES = "EXPLO_1_SIZE"),
             ask_confirmation = FALSE)
}
}
