% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeMultiMonthIsoscape.R
\name{makeMultiMonthIsoscape}
\alias{makeMultiMonthIsoscape}
\title{Make mean multi-month isoscape and error surfaces.}
\usage{
makeMultiMonthIsoscape(iso_stack, iso_se_stack, precip_stack = NULL)
}
\arguments{
\item{iso_stack}{A RasterStack containing n layers corresponding to isoscape models for n months.}

\item{iso_se_stack}{A RasterStack containing n layers corresponding to isoscape standard error maps for n months.}

\item{precip_stack}{Either a RasterStack containing n layers corresponding to precipitation amounts for n months, or NULL (assumes equal precipitation amounts.)}
}
\value{
A list containing a mean isoscape and root-sum-of-square error map
}
\description{
Converts a stack of monthly isoscape maps, monthly isoscape standard error
maps, and optionally a precipitation (amount) stack. Each stack must contain
layers corresponding to each of the target months.
}
\details{
If precip_stack is NULL, model will assume equal precipitation amounts per month.
}
