% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocks_functions.R
\name{orbi_define_blocks_for_dual_inlet}
\alias{orbi_define_blocks_for_dual_inlet}
\title{Binning raw data into blocks for dual inlet analyses}
\usage{
orbi_define_blocks_for_dual_inlet(
  dataset,
  ref_block_time.min,
  change_over_time.min,
  sample_block_time.min = ref_block_time.min,
  startup_time.min = 0,
  ref_block_name = orbi_get_option("di_ref_name"),
  sample_block_name = orbi_get_option("di_sample_name")
)
}
\arguments{
\item{dataset}{An aggregated dataset or a data frame of peaks (i.e. works directly after \code{\link[=orbi_identify_isotopocules]{orbi_identify_isotopocules()}} as well as with a tibble from \link[=orbi_get_data]{orbi_get_data(peaks = everything())} or when reading from an IsoX file)}

\item{ref_block_time.min}{time where the signal is stable when reference is analyzed}

\item{change_over_time.min}{time where the signal is unstable after switching from reference to sample or back}

\item{sample_block_time.min}{time where the signal is stable when sample is analyzed}

\item{startup_time.min}{initial time to stabilize spray}

\item{ref_block_name}{the name of the reference being measured}

\item{sample_block_name}{the name of the sample being measured}
}
\value{
A data frame (tibble) with block annotations in the form of the additional columns described below:
\itemize{
\item \code{data_group} is an integer that numbers each data group (whether that's startup, a sample block, a segment, etc.) in each file sequentially to uniquely identify groups of data that belong together - this columns is NOT static (i.e. functions like \code{\link[=orbi_adjust_block]{orbi_adjust_block()}} and \code{\link[=orbi_segment_blocks]{orbi_segment_blocks()}} will lead to renumbering) and should be used purely for grouping purposes in calculations and visualization
\item \code{block} is an integer counting the data blocks in each file (0 is the startup block)
\item \code{sample_name} is the name of the material being measured as defined by the \code{ref_block_name} and \code{sample_block_name} parameters
\item \code{segment} is an integer defines segments within individual blocks - this will be \code{NA} until the optional \code{\link[=orbi_segment_blocks]{orbi_segment_blocks()}} is called
\item \code{data_type} is a text value describing the type of data in each \code{data_group} - for a list of the main categories, call \code{orbi_get_options("data_type")}
}
}
\description{
This function sorts out (bins) data into indivual blocks of reference, sample, changeover time, and startup time.
}
