% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_isox.R
\name{orbi_filter_files}
\alias{orbi_filter_files}
\title{Basic generic data files filter}
\usage{
orbi_filter_files(
  dataset,
  filenames = NULL,
  compounds = NULL,
  isotopocules = NULL,
  time_min = NULL,
  time_max = NULL
)
}
\arguments{
\item{dataset}{An aggregated dataset or a data frame of peaks (i.e. works directly after \code{\link[=orbi_identify_isotopocules]{orbi_identify_isotopocules()}} as well as with a tibble from \link[=orbi_get_data]{orbi_get_data(peaks = everything())} or when reading from an IsoX file)}

\item{filenames}{Vector of file names to keep, keeps all if set to \code{NULL} (the default)}

\item{compounds}{Vector of compounds to keep, keeps all if set to \code{NULL} (the default)}

\item{isotopocules}{Vector of isotopocules to keep, keeps all if set to \code{NULL} (the default)}

\item{time_min}{Minimum retention time in minutes (\code{time.min}), no minimum if set to \code{NULL} (the default)}

\item{time_max}{Maximum retention time in minutes (\code{time.min}), no maximum if set to \code{NULL} (the default)}
}
\value{
Filtered tibble
}
\description{
This is a basic filter function for file names, compounds and time ranges.
For filtering isotopocules, this function calls \code{\link[=orbi_filter_isotopocules]{orbi_filter_isotopocules()}} internally (as of isoorbi version 1.5.0 \code{\link[=orbi_filter_isotopocules]{orbi_filter_isotopocules()}} can also be used directly instead of via this function).
Default value for all parameters is NULL, i.e. no filter is applied.
}
\examples{
fpath <- system.file("extdata", "testfile_flow.isox", package = "isoorbi")
df <-
  orbi_read_isox(file = fpath) |>
  orbi_simplify_isox() |>
  orbi_filter_files(
    filenames = c("s3744"),
    compounds = "HSO4-",
    isotopocules = c("M0", "34S", "18O")
  )

}
