% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R, R/processing.R
\name{orbi_plot_isotopocule_coverage}
\alias{orbi_plot_isotopocule_coverage}
\alias{orbi_get_isotopocule_coverage}
\title{Isotopocule coverage}
\usage{
orbi_plot_isotopocule_coverage(
  dataset,
  isotopocules = c(),
  x = c("scan.no", "time.min"),
  x_breaks = scales::breaks_pretty(5),
  add_data_blocks = TRUE
)

orbi_get_isotopocule_coverage(dataset)
}
\arguments{
\item{dataset}{a data frame or aggregated dataset with satellite peaks already identified (i.e. after \code{\link[=orbi_flag_satellite_peaks]{orbi_flag_satellite_peaks()}})}

\item{isotopocules}{which isotopocules to visualize, if none provided will visualize all (this may take a long time or even crash your R session if there are too many isotopocules in the data set)}

\item{x}{x-axis column for the plot, either "time.min" or "scan.no", default is "scan.no"}

\item{x_breaks}{what breaks to use for the x axis, change to make more specifid tickmarks}

\item{add_data_blocks}{add highlight for data blocks if there are any block definitions in the dataset (uses \code{\link[=orbi_add_blocks_to_plot]{orbi_add_blocks_to_plot()}}). To add blocks manually, set \code{add_data_blocks = FALSE} and manually call the \code{orbi_add_blocks_to_plot()} function afterwards.}
}
\value{
a ggplot object

summary data frame
}
\description{
The coverage of each isotopcule across scans/time is an important indicator for data completeness. These functions provide ways to summarize and visualize the isotopocule coverage in a dataset.
}
\section{Functions}{
\itemize{
\item \code{orbi_plot_isotopocule_coverage()}: visualizes isotope coverage. Weak isotopocules (if previously defined by \code{\link[=orbi_flag_weak_isotopocules]{orbi_flag_weak_isotopocules()}}) are highlighted in red.

\item \code{orbi_get_isotopocule_coverage()}: calculates which stretches of the data have data for which isotopocules. This function is usually used indicrectly by \code{\link[=orbi_plot_isotopocule_coverage]{orbi_plot_isotopocule_coverage()}} but can be called directly to investigate isotopocule coverage.

}}
