% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical-resources-queries.R
\name{get_statisticalresources_queries_agency_resource}
\alias{get_statisticalresources_queries_agency_resource}
\title{Get queries (agencyID / resourceID)}
\usage{
get_statisticalresources_queries_agency_resource(
  agencyid,
  resourceid,
  fields = "",
  lang = "es",
  as_dataframe = T
)
}
\arguments{
\item{agencyid}{(string): Identifier of the maintainer organization of the resource. A possible value is \code{ISTAC}.}

\item{resourceid}{(string): Resource identifier. A possible value is \code{C00005A_000004}.}

\item{fields}{(string): Allows you to customize the response by excluding fields from it.
\itemize{
\item The possible values are \code{-metadata} and \code{-data}.
}}

\item{lang}{(string): Language in which you want to get the answer.}

\item{as_dataframe}{(bool): If True, this function returns a namedtuple with:
\itemize{
\item dataframe: pandas dataframe built from API response.
\item codelists: mapping between codes and representations for each column.
}}
}
\description{
This function allows to obtain final data of a statistical query with a certain identifier and that also maintains a certain organization.
}
\examples{
get_statisticalresources_queries_agency_resource(
agencyid="ISTAC",
resourceid="C00005A_000004"
)
}
