% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.ivd}
\alias{plot.ivd}
\title{Plot method for ivd objects}
\usage{
\method{plot}{ivd}(
  x,
  type = "pip",
  pip_level = 0.75,
  variable = NULL,
  label_points = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of type \code{ivd}.}

\item{type}{Defaults to 'pip', other options are 'funnel' and 'outcome'.}

\item{pip_level}{Defines a value for the posterior inclusion probability. Defaults to 0.75.}

\item{variable}{Name of a specific variable. Defaults to \code{NULL}}

\item{label_points}{Should points above the pip threshold be labelled? Defaults to \code{TRUE}.}

\item{...}{Controls ggrepel aruments.}
}
\value{
Invisibly returns a \code{ggplot} object corresponding to the selected plot
type. The primary purpose of this method is the side effect of displaying the
plot.

The exact plot depends on the value of \code{type}:
\itemize{
\item \code{"pip"} — Posterior inclusion probability plot for random scale
effects.
\item \code{"funnel"} — Funnel plot showing the relation between within-cluster
standard deviation (\code{tau}) and posterior inclusion probabilities.
\item \code{"outcome"} — Outcome plot relating cluster means (\code{mu}),
posterior inclusion probability, and within-cluster SD.
}

When \code{label_points = TRUE}, labels for clusters exceeding the
\code{pip_level} threshold are added using \pkg{ggrepel} (if available).
}
\description{
Plot method for ivd objects
}
\author{
Philippe Rast
}
