% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivd.R
\name{run_MCMC_compiled_model}
\alias{run_MCMC_compiled_model}
\title{Run MCMC on an already compiled model
Exposed but internal function for future()}
\usage{
run_MCMC_compiled_model(
  compiled,
  seed,
  new_data,
  new_inits,
  niter,
  nburnin,
  useWAIC = TRUE,
  ...
)
}
\arguments{
\item{compiled}{Compiled nimble model}

\item{seed}{Seed, set by future}

\item{new_data}{Data}

\item{new_inits}{inits}

\item{niter}{Sampling iteratons}

\item{nburnin}{Number of burnin iterations}

\item{useWAIC}{Defaults to TRUE}

\item{...}{Placeholder for nimble arguments}
}
\value{
The output produced by \code{nimble::runMCMC()} when applied to a compiled
NIMBLE MCMC object.  The returned value depends on the \code{useWAIC}
argument:

\itemize{
\item If \code{useWAIC = TRUE}, a named \code{list} containing:
\itemize{
\item \code{samples}: A matrix of posterior draws
(iterations × parameters).
\item \code{WAIC}: The WAIC value computed by NIMBLE.
\item \code{...}: Additional elements returned by
\code{runMCMC()} when WAIC is enabled.
}

\item If \code{useWAIC = FALSE}, a numeric matrix containing the posterior
samples (iterations × parameters) with no additional elements.
}

This function is intended for internal use (e.g., within \code{future}
workers) and is not meant to be called directly by end users.
}
\description{
Run MCMC on an already compiled model
Exposed but internal function for future()
}
\examples{
\dontrun{
library(nimble)
# Generic nimble example
code <- nimbleCode({
  mu ~ dnorm(0, 1)
  x  ~ dnorm(mu, 1)
})

constants   <- list()
dummy_data  <- list(x = 0)
dummy_inits <- list(mu = 0)

out <- build_ivd_model(
  code        = code,
  constants   = constants,
  dummy_data  = dummy_data,
  dummy_inits = dummy_inits,
  useWAIC     = FALSE
)

str(out)
}
}
