% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/span.R
\name{iv_pairwise_span}
\alias{iv_pairwise_span}
\title{Pairwise span}
\usage{
iv_pairwise_span(x, y)
}
\arguments{
\item{x, y}{\verb{[iv]}

A pair of interval vectors.

These will be cast to the same type, and recycled against each other.}
}
\value{
An iv the same size and type as \code{x} and \code{y}.
}
\description{
\code{iv_pairwise_span()} computes the \emph{pairwise} "span" between the i-th interval
of \code{x} and the i-th interval of \code{y}. The pairwise span of two intervals is
a new interval containing the minimum start and maximum end of the original
intervals. It is similar to \code{\link[=iv_pairwise_set_union]{iv_pairwise_set_union()}}, except it fills across
gaps.
}
\examples{
x <- iv_pairs(c(1, 3), c(6, 8))
y <- iv_pairs(c(5, 7), c(2, 3))

# Can't take the set union when there are gaps
try(iv_pairwise_set_union(x, y))

# But you can compute the span of the intervals
iv_pairwise_span(x, y)
}
