% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba.r
\name{rlengths}
\alias{rlengths}
\title{lengths for recursive lists}
\usage{
rlengths(x, doSum = NULL, ...)
}
\arguments{
\item{x}{\code{list} or vector}

\item{doSum}{\code{logical} indicating whether to return the overall sum
of lengths. When \code{NULL} it will return the aggregate length of
each list element in \code{x}. When \code{FALSE} it will return the same
list structure of x, with the length of each. When \code{TRUE} it will
return the total length of all elements in \code{x} as one value.}

\item{...}{additional parameters are ignored}
}
\value{
\code{integer} value, vector, or list:
\itemize{
\item When \verb{doSum is NULL} (default) it returns an \code{integer} vector
with length \code{length(x)} and names \code{names(x)},
whose values are the total number of elements in each item in
\code{x} after running \code{base::unlist()}.
\item When \code{doSum=="TRUE"}, it returns the single \code{integer} length of
all elements in \code{x}.
\item When \code{doSum=="FALSE"}, it returns the full structure of \code{x} with the
\code{integer} length of each element.
}

The parameter \code{doSum} is intended for internal use, during
recursive calls of \code{rlengths()} to itself. When \verb{doSum is NULL} or
\code{TRUE}, recursive calls to \code{rlengths()} set \code{doSum=TRUE}.
}
\description{
lengths for recursive lists
}
\details{
This function takes a list as input, and returns the length
of each list element after running \code{base::unlist()}.
}
\examples{
x <- list(
   A=list(
      A1=nameVector(1:3, letters[1:3]),
      A2=list(
         A1a=nameVector(4:7, letters[4:7]),
         A1b=nameVector(11:14, letters[11:14]))),
   B=list(B1=nameVector(1:9, letters[1:9]),
      B2=nameVector(20:25, letters[20:25])));
# default lengths(x) shows length=2 for A and B
lengths(x)
# rlengths(x) shows the total length of A and B
rlengths(x)

}
\seealso{
Other jam list functions: 
\code{\link{cPaste}()},
\code{\link{heads}()},
\code{\link{jam_rapply}()},
\code{\link{list2df}()},
\code{\link{mergeAllXY}()},
\code{\link{mixedSorts}()},
\code{\link{rbindList}()},
\code{\link{relist_named}()},
\code{\link{sclass}()},
\code{\link{sdim}()},
\code{\link{uniques}()},
\code{\link{unnestList}()}
}
\concept{jam list functions}
