% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-shadowText.R
\name{shadowText_options}
\alias{shadowText_options}
\title{Get and set options for shadowText}
\usage{
shadowText_options(
  r = getOption("jam.shadow.r", 0.15),
  n = getOption("jam.shadow.n", 8),
  outline = getOption("jam.outline", TRUE),
  alphaOutline = getOption("jam.alphaOutline", 0.4),
  shadow = getOption("jam.shadow", FALSE),
  shadowColor = getOption("jam.shadowColor", "black"),
  alphaShadow = getOption("jam.alphaShadow", 0.2),
  r_ex = 1,
  alpha_ex = 1,
  preset = c("none", "default", "bold", "bold white", "bold black", "both", "shadow",
    "bold shadow", "bold white shadow", "bold black shadow", "bold both"),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{r}{\code{numeric} radius used for outline or shadow}

\item{n}{\code{numeric} number of shadow steps to render around each text label}

\item{outline}{\code{logical} indicating whether to render shadowText
as an outline (default), or when \code{outline=FALSE} it renders a
drop shadow offset using \code{offset} which by default is slightly
down and to the right of the text labels.}

\item{alphaOutline}{\code{numeric} value for alpha transparency used for
label outlines when \code{outline=TRUE}, with values expected
between 0 (fully transparent) and 1 (not transparent).}

\item{shadow}{\code{logical} indicating whether to render shadowText as a
shadow, or not (default).}

\item{shadowColor}{\code{character} R color which defines the color used
for the outline or shadow for each text label.}

\item{alphaShadow}{\code{numeric} value for alpha transparency used for
label shadows when \code{shadow=TRUE}, with values expected
between 0 (fully transparent) and 1 (not transparent).}

\item{r_ex}{\code{numeric} expansion factor used to adjust the radius \code{r}.
The value for \code{r} is defined based upon the arguments provided,
then is multiplied by the \code{r_ex} expansion factor.
The result is stored in option "jam.shadow.r".}

\item{alpha_ex}{\code{numeric} expansion factor used to adjust the
alpha transparency of both \code{alphaOutline} and \code{alphaShadow}.
Values will be maintained no lower than 0 and no higher than 1.
The values for \code{alphaOutline} and \code{alphaShadow} are defined
based upon the arguments provided, then are multiplied by the
\code{alpha_ex} expansion factor.
The result is clipped to range 0,1 using \code{jamba::noiseFloor()}.
The resulting values are stored in options
"jam.alphaOutline" and "jam.alphaShadow", respectively.}

\item{preset}{\code{character} string which defines a preset with
associated settings. Any value other than \code{"none"} will cause
all other options to use the preset settings.
\itemize{
\item \code{"none"}: no preset settings are applied
\item \code{"default"}: reverts all options to the original default values,
which produces an outline, and not a drop shadow.
The color will use \code{shadowColor} which allows using all other settings
from this preset, except with custom color.
\item \code{"bold"}: makes output produce visibly more distinct outline,
with no drop shadow.
The color will use \code{shadowColor} which allows using all other settings
from this preset, except with custom color.
\item \code{"bold white"}: same as "bold" except default text color is white
\item \code{"bold black"}: same as "bold" except default text color is black
\item \code{"both"}: applies "default" and enables drop shadow
\item \code{"shadow"}: uses suggested default values to produce a drop shadow,
and not an outline.
The color will use \code{shadowColor} which allows using all other settings
from this preset, except with custom color.
\item \code{"bold shadow"}: same as "shadow" except the shadow is more distinct.
The color will use \code{shadowColor} which allows using all other settings
from this preset, except with custom color.
\item \code{"bold white shadow"}: same as "bold shadow" with white shadow
\item \code{"bold black shadow"}: same as "bold shadow" with black shadow
\item \code{"bold both"}: same as "bold" except also enables bold shadow
}}

\item{verbose}{\code{logical} indicating whether to print verbose output}

\item{...}{additional arguments are ignored.}
}
\value{
\code{list} with the following options for \code{shadowText()}:
\itemize{
\item jam.shadow.r
\item jam.shadow.n
\item jam.outline
\item jam.alphaOutline
\item jam.shadow
\item jam.shadowColor
\item jam.alphaShadow
}
}
\description{
Get and set options for shadowText
}
\details{
This function is intended to be a convenient method to get and set
options to be used with \code{jamba::shadowText()}.
This function stores the resulting values in \code{options()} for
use by \code{shadowText()}.
}
\examples{
nullPlot(doBoxes=FALSE, xlim=c(-1, 4), ylim=c(-1, 4), asp=1);
usrBox(fill="grey")
cex <- 1.2
graphics::axis(1);graphics::axis(2, las=2)
shadowText_options(preset="default")
shadowText(x=0, y=3, "default", cex=cex)
shadowText_options(preset="bold")
shadowText(x=0, y=2, "bold", cex=cex)
shadowText_options(preset="bold white")
shadowText(x=0, y=1, col="black", "bold white", cex=cex)
shadowText_options(preset="bold black")
shadowText(x=0, y=0, col="white", "bold black", cex=cex)
shadowText_options(preset="shadow")
shadowText(x=3, y=3, "shadow", cex=cex)
shadowText_options(preset="bold shadow")
shadowText(x=3, y=2, "bold shadow", cex=cex)
shadowText_options(preset="bold white shadow")
shadowText(x=3, y=1, col="black", "bold white shadow", cex=cex)
shadowText_options(preset="bold black shadow")
shadowText(x=3, y=0, col="white", "bold black shadow", cex=cex)
shadowText_options(preset="both")
shadowText(x=1.5, y=3, col="white", "both", cex=cex)
shadowText(x=1.5, y=2.5, col="black", "both", cex=cex)
shadowText_options(preset="bold both")
shadowText(x=1.5, y=2, col="white", "bold both", cex=cex)
shadowText(x=1.5, y=1, col="black", "bold both", cex=cex)
shadowText(x=1.5, y=0.5, col="blue3", "bold both", cex=cex, font=2)
shadowText(x=1.5, y=0, col="indianred1", "bold both", cex=cex, font=2)
shadowText_options(preset="default")

}
\seealso{
Other jam plot functions: 
\code{\link{adjustAxisLabelMargins}()},
\code{\link{coordPresets}()},
\code{\link{decideMfrow}()},
\code{\link{drawLabels}()},
\code{\link{getPlotAspect}()},
\code{\link{groupedAxis}()},
\code{\link{imageByColors}()},
\code{\link{imageDefault}()},
\code{\link{minorLogTicksAxis}()},
\code{\link{nullPlot}()},
\code{\link{plotPolygonDensity}()},
\code{\link{plotRidges}()},
\code{\link{plotSmoothScatter}()},
\code{\link{shadowText}()},
\code{\link{showColors}()},
\code{\link{sqrtAxis}()},
\code{\link{usrBox}()}
}
\concept{jam plot functions}
