% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order.R
\name{max_n}
\alias{max_n}
\alias{min_n}
\title{Maxima and Minima \emph{n} elements}
\usage{
max_n(x, n = 1L)

min_n(x, n = 1)
}
\arguments{
\item{x}{Data vector}

\item{n}{Number of observations to select}
}
\value{
A \code{vector} containing the maximum/minimum of \eqn{n} elements.
}
\description{
Obtain the Maximum or Minimum \emph{n} elements from a vector.
}
\details{
The underlying function sorts the data using \code{\link[base:sort]{base::sort()}} and then extracts
out the appropriate n-back or n-forward values.

As a result of the sorting procedure, this is an inefficient function.
}
\examples{

x = 1:10

# Defaults to traditional max
# This is more costly to compute than using the regular max function.
max_n(x) 

# Retrieve top two observations (highest first)
max_n(x, 2)

# Missing values have no effect on the sorting procedure
x[9] = NA
max_n(x, 3)

# Defaults to traditional min.
# This is more costly to compute than using the regular min function.
min_n(x)
min(x)

# Retrieve bottom two observations (lowest first)
min_n(x, 2)

# Missing values have no effect on the sorting procedure
x[2] = NA
min_n(x, 3)
}
