% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_Cauchy.R
\name{Cauchy}
\alias{Cauchy}
\alias{d,Cauchy,numeric-method}
\alias{p,Cauchy,numeric-method}
\alias{qn,Cauchy,numeric-method}
\alias{r,Cauchy,numeric-method}
\alias{mean,Cauchy-method}
\alias{median,Cauchy-method}
\alias{mode,Cauchy-method}
\alias{var,Cauchy-method}
\alias{sd,Cauchy-method}
\alias{skew,Cauchy-method}
\alias{kurt,Cauchy-method}
\alias{entro,Cauchy-method}
\alias{finf,Cauchy-method}
\alias{llcauchy}
\alias{ll,Cauchy,numeric-method}
\alias{ecauchy}
\alias{mle,Cauchy,numeric-method}
\alias{me,Cauchy,numeric-method}
\alias{vcauchy}
\alias{avar_mle,Cauchy-method}
\title{Cauchy Distribution}
\usage{
Cauchy(location = 0, scale = 1)

\S4method{d}{Cauchy,numeric}(distr, x, log = FALSE)

\S4method{p}{Cauchy,numeric}(distr, q, lower.tail = TRUE, log.p = FALSE)

\S4method{qn}{Cauchy,numeric}(distr, p, lower.tail = TRUE, log.p = FALSE)

\S4method{r}{Cauchy,numeric}(distr, n)

\S4method{mean}{Cauchy}(x)

\S4method{median}{Cauchy}(x)

\S4method{mode}{Cauchy}(x)

\S4method{var}{Cauchy}(x)

\S4method{sd}{Cauchy}(x)

\S4method{skew}{Cauchy}(x)

\S4method{kurt}{Cauchy}(x)

\S4method{entro}{Cauchy}(x)

\S4method{finf}{Cauchy}(x)

llcauchy(x, location, scale)

\S4method{ll}{Cauchy,numeric}(distr, x)

ecauchy(x, type = "mle", ...)

\S4method{mle}{Cauchy,numeric}(
  distr,
  x,
  par0 = "me",
  method = "L-BFGS-B",
  lower = c(-Inf, 1e-05),
  upper = c(Inf, Inf),
  na.rm = FALSE
)

\S4method{me}{Cauchy,numeric}(distr, x, na.rm = FALSE)

vcauchy(location, scale, type = "mle")

\S4method{avar_mle}{Cauchy}(distr)
}
\arguments{
\item{location, scale}{numeric. Location and scale parameters.}

\item{distr}{an object of class \code{Cauchy}.}

\item{x}{For the density function, \code{x} is a numeric vector of quantiles. For
the moments functions, \code{x} is an object of class \code{Cauchy}. For the
log-likelihood and the estimation functions, \code{x} is the sample of
observations.}

\item{log, log.p}{logical. Should the logarithm of the probability be
returned?}

\item{q}{numeric. Vector of quantiles.}

\item{lower.tail}{logical. If TRUE (default), probabilities are
\eqn{P(X \leq x)}, otherwise \eqn{P(X > x)}.}

\item{p}{numeric. Vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to
be the number required.}

\item{type}{character, case ignored. The estimator type (mle or me).}

\item{...}{extra arguments.}

\item{par0, method, lower, upper}{arguments passed to optim for the mle
optimization.}

\item{na.rm}{logical. Should the \code{NA} values be removed?}
}
\value{
Each type of function returns a different type of object:
\itemize{
\item Distribution Functions: When supplied with one argument (\code{distr}), the
\code{d()}, \code{p()}, \code{q()}, \code{r()}, \code{ll()} functions return the density, cumulative
probability, quantile, random sample generator, and log-likelihood functions,
respectively. When supplied with both arguments (\code{distr} and \code{x}), they
evaluate the aforementioned functions directly.
\item Moments: Returns a numeric, either vector or matrix depending on the moment
and the distribution. The \code{moments()} function returns a list with all the
available methods.
\item Estimation: Returns a list, the estimators of the unknown parameters. Note
that in distribution families like the binomial, multinomial, and negative
binomial, the size is not returned, since it is considered known.
\item Variance: Returns a named matrix. The asymptotic covariance matrix of the
estimator.
}
}
\description{
The Cauchy distribution is an absolute continuous probability distribution
characterized by its location parameter \eqn{x_0} and scale parameter
\eqn{\gamma > 0}.
}
\details{
The probability density function (PDF) of the Cauchy distribution is given
by: \deqn{ f(x; x_0, \gamma) = \frac{1}{\pi \gamma \left[1 + \left(\frac{x -
x_0}{\gamma}\right)^2\right]}.}

The MLE of the Cauchy distribution parameters is not available in closed form
and has to be approximated numerically. This is done with \code{optim()}.
The default method used is the L-BFGS-B method with lower bounds
\code{c(-Inf, 1e-5)} and upper bounds \code{c(Inf, Inf)}. The \code{par0} argument can
either be a numeric (both elements satisfying \verb{lower <= par0 <= upper})
or a character specifying the closed-form estimator to be used as
initialization for the algorithm (\code{"me"} - the default value).

Note that the \code{me()} estimator for the Cauchy distribution is not a
\emph{moment} estimator; it utilizes the sample median instead of the sample
mean.
}
\examples{
# -----------------------------------------------------
# Cauchy Distribution Example
# -----------------------------------------------------

# Create the distribution
x0 <- 3 ; scale <- 5
D <- Cauchy(x0, scale)

# ------------------
# dpqr Functions
# ------------------

d(D, c(-5, 3, 10)) # density function
p(D, c(-5, 3, 10)) # distribution function
qn(D, c(0.4, 0.8)) # inverse distribution function
x <- r(D, 100) # random generator function

# alternative way to use the function
df <- d(D) ; df(x) # df is a function itself

# ------------------
# Moments
# ------------------

median(D) # Median
mode(D) # Mode
entro(D) # Entropy
finf(D) # Fisher Information Matrix

# ------------------
# Point Estimation
# ------------------

ll(D, x)
llcauchy(x, x0, scale)

ecauchy(x, type = "mle")
ecauchy(x, type = "me")

mle(D, x)
me(D, x)
e(D, x, type = "mle")

mle("cauchy", x) # the distr argument can be a character

# ------------------
# Estimator Variance
# ------------------

vcauchy(x0, scale, type = "mle")
avar_mle(D)
v(D, type = "mle")
}
\seealso{
Functions from the \code{stats} package: \code{\link[=dcauchy]{dcauchy()}}, \code{\link[=pcauchy]{pcauchy()}}, \code{\link[=qcauchy]{qcauchy()}},
\code{\link[=rcauchy]{rcauchy()}}
}
