% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrSiCKLSNMF.R
\name{GenerateWmatricesandHmatrix}
\alias{GenerateWmatricesandHmatrix}
\title{Initialize the \eqn{\mathbf{W}} matrices in each modality and the shared \eqn{\mathbf{H}} matrix}
\usage{
GenerateWmatricesandHmatrix(
  SickleJr,
  d = 10,
  random = FALSE,
  numberReps = 100,
  seed = 5,
  minibatch = FALSE,
  batchsize = -1,
  random_W_updates = FALSE,
  subsample = 1:dim(SickleJr@count.matrices[[1]])[2],
  usesvd = FALSE
)
}
\arguments{
\item{SickleJr}{An object of class SickleJr}

\item{d}{Number of latent factors to use: defaults to 10}

\item{random}{Boolean indicating whether to use random initialization (\code{TRUE}) or NNDSVD (\code{FALSE}): default is NNDSVD}

\item{numberReps}{Number of random initializations to use: default is 5}

\item{seed}{Random seed for reproducibility of random initializations}

\item{minibatch}{Indicates whether or not to use the mini-batch algorithm}

\item{batchsize}{Size of batches for mini-batch NMF}

\item{random_W_updates}{Indicates whether to only update each \eqn{\mathbf{W}^v} once per round of
\eqn{\mathbf{H}} updates; only appropriate for mini-batch algorithms}

\item{subsample}{A vector of values to use for subsampling; only appropriate
when determining proper values for d.}

\item{usesvd}{Indicates whether to use \code{R}'s singular value decomposition function
svd (TRUE) or irlba (FALSE), default is \code{FALSE}; use irlba for larger datasets
to increase performance}
}
\value{
SickleJr An object of class SickleJr with the \eqn{\mathbf{W}^v} matrices and \eqn{\mathbf{H}} matrix added.
}
\description{
Create the \eqn{\mathbf{W}^v} matrices and \eqn{\mathbf{H}} matrix via non-negative double singular
value decomposition (NNDSVD) (Boutsidis and Gallopoulus 2008; Gaujoux and Seoighe 2010)
or randomization. For randomization, the algorithm runs for 10 rounds
for the desired number of random initializations and picks the \eqn{\mathbf{W}^v} matrices and \eqn{\mathbf{H}} matrix with
the lowest achieved loss.
}
\examples{
SimSickleJrSmall<-SetLambdasandRowReg(SimSickleJrSmall,
lambdaWlist=list(10,50),lambdaH=500,rowReg="None")
SimSickleJrSmall<-GenerateWmatricesandHmatrix(SimSickleJrSmall,d=5,usesvd=TRUE)

}
\references{
\insertRef{Boutsidis2008}{jrSiCKLSNMF}

\insertRef{NMFinR}{jrSiCKLSNMF}
}
