% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jshint.R
\name{jshint}
\alias{jshint}
\title{Static analysis tool for JavaScript}
\usage{
jshint(text, ..., globals = NULL)
}
\arguments{
\item{text}{a string of JavaScript code}

\item{...}{additional jshint \href{https://jshint.com/docs/options/}{configuration options}}

\item{globals}{a white list of global variables that are not formally defined in the source code}
}
\value{
a data frame where each row represents a jshint error or \code{NULL} if there were no errors
}
\description{
JSHint is a community-driven tool to detect errors and potential problems in JavaScript code.
It is very flexible so you can easily adjust it to your particular coding guidelines and
the environment you expect your code to execute in.
}
\examples{
code = "var foo = 123"
jshint(code)
jshint(code, asi = TRUE)
}
