% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/karlen-package.R
\docType{package}
\name{karlen-package}
\alias{karlen-package}
\title{karlen: Real-Time PCR Data Sets by Karlen et al. (2007)}
\description{
Real-time quantitative polymerase chain reaction (qPCR) data sets by Karlen et al. (2007) \doi{10.1186/1471-2105-8-131}. Provides one single tabular tidy data set in long format, encompassing 32 dilution series, for seven PCR targets and four biological samples. The targeted amplicons are within the murine genes: Cav1, Ccn2, Eln, Fn1, Rpl27, Hspg2, and Serpine1, respectively. Dilution series: scheme 1 (Cav1, Eln, Hspg2, Serpine1): 1-fold, 10-fold, 50-fold, and 100-fold; scheme 2 (Ccn2, Rpl27, Fn1): 1-fold, 10-fold, 50-fold, 100-fold and 1000-fold. For each concentration there are five replicates, except for the 1000-fold concentration, where only two replicates were performed. Each amplification curve is 40 cycles long. Original raw data file is Additional file 2 from "Statistical significance of quantitative PCR" by Y. Karlen, A. McNair, S. Perseguers, C. Mazza, and N. Mermod (2007) \url{https://static-content.springer.com/esm/art\%3A10.1186\%2F1471-2105-8-131/MediaObjects/12859_2006_1503_MOESM2_ESM.ZIP}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://rmagno.eu/karlen/}
  \item \url{https://github.com/ramiromagno/karlen}
  \item Report bugs at \url{https://github.com/ramiromagno/karlen/issues}
}

}
\author{
\strong{Maintainer}: Ramiro Magno \email{rmagno@pattern.institute} (\href{https://orcid.org/0000-0001-5226-3441}{ORCID})

Other contributors:
\itemize{
  \item Pattern Institute [copyright holder, funder]
}

}
\keyword{internal}
