% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.r
\name{prcomp}
\alias{prcomp}
\alias{prcomp.shaq}
\title{Principal Components Analysis}
\usage{
\method{prcomp}{shaq}(x, retx = TRUE, center = TRUE, scale. = FALSE,
  tol = NULL, ...)
}
\arguments{
\item{x}{A shaq.}

\item{retx}{Should the rotated variables be returned?}

\item{center}{Should columns are zero centered?}

\item{scale.}{Should columns are rescaled to unit variance?}

\item{tol}{Ignored.}

\item{...}{Ignored.}
}
\value{
A list of elements \code{sdev}, \code{rotation}, \code{center}, \code{scale},
and \code{x}, as with R's own \code{prcomp()}.  The elements are,
respectively, a regular vector, a regular matrix, a regular vector, a regular
vector, and a shaq.
}
\description{
Performs the principal components analysis.
}
\details{
\code{prcomp()} performs the principal components analysis on the data
matrix by taking the SVD. Sometimes core R and kazaam will disagree
slightly in what the rotated variables are because of how the SVD is
caluclated.
}
\section{Communication}{

The communication is an \code{allreduce()} call, quadratic on the number of
columns.  Most of the run time should be dominated by relatively expensive
 local operations.
}

\examples{
\dontrun{
library(kazaam)
x = ranshaq(runif, 10, 3)
pca = prcomp(x)

comm.print(pca)

finalize()
}

}
