% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weiplot.R
\name{weilines}
\alias{weilines}
\title{Add Lines onto a Weibull Plot}
\usage{
weilines(x, y, lty = NULL, lwd = NULL, col = "black", type = "l",
  pch = 0)
}
\arguments{
\item{x}{vector of values}

\item{y}{vector of values the same length as x}

\item{lty}{line type}

\item{lwd}{line width}

\item{col}{line color}

\item{type}{type of plotting}

\item{pch}{symbol type for type = "b"}
}
\description{
Weibull distributed data plots as a straight line on log-log plot using
\code{wlines()}. It is best used after function \code{wplot()} has been
called.
}
\details{
A Weibull plot uses log paper and has log(1/(1-F(x)) versus x,
        where the data values x have an empirical cdf of F(x). The plot
        margins may need to be adjusted so that the right hand axis is
        visible.
}
\examples{

dummy <- c(0,0)
weiplot(dummy, xlim = c(1e-3, 10), type = "n")
x <- 10^seq(-3, 2, length = 100)
weilines(x, pexp(x), col = "red")
weilines(x, pweibull(x, 2), col = "blue")
weilines(x, pweibull(x, 3), col = "green")
}
\seealso{
\code{wplot()} creates the Weibull plot
}

