% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization.R
\name{cosnormX}
\alias{cosnormX}
\title{Cosine normalization of a matrix}
\usage{
cosnormX(X, rows = TRUE)
}
\arguments{
\item{X}{Numeric matrix or data.frame of any size.}

\item{rows}{If TRUE, the operation is done by row; otherwise, it is done by
column. (Defaults: TRUE).}
}
\value{
Cosine-normalized X.
}
\description{
Normalizes a numeric matrix dividing each row (if rows=TRUE) or column (if rows=FALSE)
by their L2 norm. Thus, each row (or column) has unit norm.
}
\examples{
dat <- matrix(rnorm(50),ncol=5,nrow=10)
cosnormX(dat)
}
