% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KinPairSimulation.R
\name{access_sigmas}
\alias{access_sigmas}
\alias{posigma}
\alias{posigma<-}
\alias{initsigma}
\alias{initsigma<-}
\alias{breedsigma}
\alias{breedsigma<-}
\alias{gravsigma}
\alias{gravsigma<-}
\alias{ovisigma}
\alias{ovisigma<-}
\alias{posigma,KinPairSimulation-method}
\alias{initsigma,KinPairSimulation-method}
\alias{breedsigma,KinPairSimulation-method}
\alias{gravsigma,KinPairSimulation-method}
\alias{ovisigma,KinPairSimulation-method}
\title{Access or assign dispersal sigmas of \code{\link{KinPairSimulation}} objects}
\usage{
posigma(x)

posigma(x) <- value

initsigma(x)

initsigma(x) <- value

breedsigma(x)

breedsigma(x) <- value

gravsigma(x)

gravsigma(x) <- value

ovisigma(x)

ovisigma(x) <- value

\S4method{posigma}{KinPairSimulation}(x)

\S4method{initsigma}{KinPairSimulation}(x)

\S4method{breedsigma}{KinPairSimulation}(x)

\S4method{gravsigma}{KinPairSimulation}(x)

\S4method{ovisigma}{KinPairSimulation}(x)
}
\arguments{
\item{x}{object of class \code{KinPairSimulation}}

\item{value}{new value to assign}

\item{KinPairSimulation}{object of class KinPairSimulation}
}
\value{
\code{numeric} value of specified sigma parameter or modified \code{KinPairSimulation} object
}
\description{
These generics & methods work with \code{KinPairSimulation} objects to access & modify information about the dispersal
sigma parameters that define the stored simulation. The \code{posigma()} method accesses the single dispersal parameter
stored in a simulation with \code{simtype == "simple"}. The remaining parameters access the dispersal parameters stored
in a simulation with \code{simtype == "composite"}. The dispersal kernel sigma parameters of \code{simtype == "custom"}
simulations are not yet implemented here. Assignment operations currently only exist as generics (they are not yet applied
to the \code{KinPairSimulation} class).
}
\section{Functions}{
\itemize{
\item \code{posigma,KinPairSimulation-method}: 

\item \code{initsigma,KinPairSimulation-method}: 

\item \code{breedsigma,KinPairSimulation-method}: 

\item \code{gravsigma,KinPairSimulation-method}: 

\item \code{ovisigma,KinPairSimulation-method}: 
}}

\seealso{
Other kpsmethods: 
\code{\link{filter_methods}},
\code{\link{kernelshape}()},
\code{\link{kerneltype}()},
\code{\link{simtype}()}
}
\concept{kpsmethods}
