% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kriging.auto.R
\name{kriging.auto}
\alias{kriging.auto}
\title{Automatic Kriging Interpolation with Factor Analysis Preprocessing}
\usage{
kriging.auto(
  data,
  num_fac = 3,
  grid_cell_size = NA,
  num_init_test = 8,
  num_fin_test = 200,
  nugget_bounds = c(0, 0.2),
  sill_bounds = c(0, 20000),
  range_bounds = c(0, 25000)
)
}
\arguments{
\item{data}{A dataset of class data.frame. The data should contain 'C_X' and 'C_Y' columns
representing the x and y coordinates of the data points and excludes any rank,
ID, or column not for analysis.}

\item{num_fac}{A numeric value indicating the number of factors to analyze. Default is 3.}

\item{grid_cell_size}{The desired cell size for the grid. Default is NA, which will calculate the cell size based on the average distance between data points.}

\item{num_init_test}{The number of random starts for initial model optimization. Default is 8}

\item{num_fin_test}{The number of random starts for final model optimization. Default is 200}

\item{nugget_bounds}{A numeric vector specifying the lower and upper bounds for the nugget parameter during optimization. Default is c(0, .2).}

\item{sill_bounds}{A numeric vector specifying the lower and upper bounds for the sill parameter during optimization. Default is c(0, 20000).}

\item{range_bounds}{A numeric vector specifying the lower and upper bounds for the range parameter during optimization. Default is c(0, 25000).}
}
\value{
A data frame with interpolated data for the whole grid. Data frame has columns: "C_X",
"C_Y", "value", "FA". "C_X" and "C_Y" are the coordinates, "value" is the interpolated value,
and "FA" indicates the relevant factor the value corresponds to.
}
\description{
This function performs automatic kriging interpolation with factor analysis
preprocessing on input data. The optimization may not work as intended use higher
num_init_test and num_fin_test values or run the function multiples times to
ensure an accurate result.
}
\examples{
\donttest{
data("Klovan_Row80")
kriging.auto(Klovan_Row80)
}

}
