% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCBI_Genome.R
\name{NCBI_Genome}
\alias{NCBI_Genome}
\title{Class constructor - build NCBI Genome object}
\description{
Class constructor - build NCBI Genome object

Class constructor - build NCBI Genome object
}
\details{
NCBI FASTA file contain nucleotide accession number at the headers, followed
by some information about the sequence whether they are chromosome,
plasmid, or mictochondria, their assembly status, etc.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{fasta_file}}{A path to FASTA file.
fasta files.}

\item{\code{genome_name}}{A genome name.}

\item{\code{db}}{NCBI database: "refseq" or "genbank"}

\item{\code{seq}}{A chromosome-named list of sequences.}

\item{\code{seq_len}}{A chromosome-named vector of sequence length.}

\item{\code{load_limit}}{Maximum chromosome sequences loaded.}

\item{\code{mask}}{Genome mask status: "hard", "soft", or "none".}

\item{\code{use_UCSC_name}}{Use UCSC style chromosome name? Default to FALSE.}

\item{\code{headers}}{A chromosome-named vector of headers.}

\item{\code{avail_seqs}}{Available chromosome sequences in the fasta file.}

\item{\code{asm}}{Assembly summary.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-NCBI_Genome-new}{\code{NCBI_Genome$new()}}
\item \href{#method-NCBI_Genome-print}{\code{NCBI_Genome$print()}}
\item \href{#method-NCBI_Genome-get_assembly_report}{\code{NCBI_Genome$get_assembly_report()}}
\item \href{#method-NCBI_Genome-clone}{\code{NCBI_Genome$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NCBI_Genome-new"></a>}}
\if{latex}{\out{\hypertarget{method-NCBI_Genome-new}{}}}
\subsection{Method \code{new()}}{
Create a new NCBI Genome class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCBI_Genome$new(
  genome.name,
  db,
  fasta.file,
  asm,
  mask,
  use.UCSC.name,
  load.limit
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{genome.name}}{A genome name. NCBI genome is included with kmeRtone.}

\item{\code{db}}{NCBI database: "refseq" or "genbank".}

\item{\code{fasta.file}}{A path to the NCBI-style fasta files. This is for
user's own FASTA file.}

\item{\code{asm}}{NCBI assembly summary.}

\item{\code{mask}}{Genome mask status: "hard", "soft", or "none". Default is
"none".}

\item{\code{use.UCSC.name}}{Use UCSC style chromosome name? Default to FALSE.}

\item{\code{load.limit}}{Maximum chromosome sequences loaded. Default is 1.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \verb{NCBI Genome} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NCBI_Genome-["></a>}}
\if{latex}{\out{\hypertarget{method-NCBI_Genome-[}{}}}
\subsection{Method \code{[()}}{
Calling chromosome sequence by loading on demand.
Maximum load is determine by load_limit field.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCBI_Genome$[(chr.names, reload = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{chr.names}}{Chromosome name. It can be a vector of chromosomes.}

\item{\code{reload}}{Reload the sequence from the fasta_file.
Default is FALSE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A single or list of sequence of requested chromosome.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NCBI_Genome-print"></a>}}
\if{latex}{\out{\hypertarget{method-NCBI_Genome-print}{}}}
\subsection{Method \code{print()}}{
Print summary of \code{Genome} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCBI_Genome$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Message of \code{Genome} object summary.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NCBI_Genome-get_assembly_report"></a>}}
\if{latex}{\out{\hypertarget{method-NCBI_Genome-get_assembly_report}{}}}
\subsection{Method \code{get_assembly_report()}}{
Get NCBI assembly report for the genome.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCBI_Genome$get_assembly_report()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Message of \code{Genome} object summary.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NCBI_Genome-clone"></a>}}
\if{latex}{\out{\hypertarget{method-NCBI_Genome-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCBI_Genome$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
