% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{countMidPatternContext2}
\alias{countMidPatternContext2}
\title{Locate a middle sequence pattern and count its sequence context.}
\usage{
countMidPatternContext2(sequence, mid_pattern, window, context_patterns)
}
\arguments{
\item{sequence}{A string representing the sequence to be analyzed.}

\item{mid_pattern}{A string representing the middle pattern to search for within the sequence.}

\item{window}{An integer specifying the size of the surrounding window around the middle pattern.}

\item{context_patterns}{A vector of strings representing the context patterns to search for within the window.}
}
\value{
A std::unordered_map<int,int> where keys are the counts of context patterns found
and values are the frequencies of these counts.
}
\description{
This function searches for a specified middle pattern within a given sequence.
It then counts the occurrences of specific context patterns within a defined window
size around the middle pattern. The function returns a map where keys are the
counts of context patterns found and values are the frequencies of these counts.
}
