% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kuzu.R
\name{as_tibble.kuzu.query_result.QueryResult}
\alias{as_tibble.kuzu.query_result.QueryResult}
\title{Convert a Kuzu Query Result to a Tibble}
\usage{
\method{as_tibble}{kuzu.query_result.QueryResult}(x, ...)
}
\arguments{
\item{x}{A Kuzu query result object.}

\item{...}{Additional arguments passed to \code{as_tibble}.}
}
\value{
A \code{tibble} containing the query results.
}
\description{
Provides an S3 method to convert a Kuzu query result object into a
\code{tibble}. This requires the \code{tibble} package to be installed.
}
\examples{
\donttest{
if (requireNamespace("tibble", quietly = TRUE)) {
  conn <- kuzu_connection(":memory:")
  kuzu_execute(conn, "CREATE NODE TABLE User(name STRING, age INT64,
  PRIMARY KEY (name))")
  kuzu_execute(conn, "CREATE (:User {name: 'Alice', age: 25})")
  result <- kuzu_execute(conn, "MATCH (a:User) RETURN a.name, a.age")

  # Convert the result to a tibble
  tbl <- tibble::as_tibble(result)
  print(tbl)
}
}
}
