% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kvh.R
\name{kvh_get_matrix}
\alias{kvh_get_matrix}
\title{Get matrix from kvh file}
\usage{
kvh_get_matrix(f, v)
}
\arguments{
\item{f}{connection from which kvh file can be read}

\item{v}{character vector of key-subkeys pointing to a matrix}
}
\value{
matrix read from kvh
}
\description{
Given a read connection to kvh file and a vector of keys pointing to a matrix, return this matrix
}
\details{
It is expected that matrix in the kvh file has its upper-leftmost item called "row_col" and it has
rownames in the first column and colnames in the first row.
}
\examples{
# write a test matrix
obj2kvh(list(comment="this is a test matrix",  m=diag(2)), "li", "test.kvh")
# read it back
mr=kvh_get_matrix(file("test.kvh"), c("li", "m"))
# clean
unlink("test.kvh")

}
