% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcor.comp.R
\name{lcor.comp}
\alias{lcor.comp}
\title{Lancaster correlation and its components}
\usage{
lcor.comp(x, y = NULL, type = c("rank", "linear"), plot = FALSE)
}
\arguments{
\item{x}{a numeric vector, or a matrix or data frame with two columns.}

\item{y}{NULL (default) or a vector with same length as x.}

\item{type}{a character string indicating which lancaster correlation is to be computed. One of "rank" (default), or "linear": can be abbreviated.}

\item{plot}{logical; if TRUE, scatterplots of the transformed x and y values and of their squares are drawn.}
}
\value{
a vector containing the two components rho1 and rho2 and the sample Lancaster correlation.
}
\description{
Computes the Lancaster correlation coefficient and its components.
}
\details{
For more details see \code{\link{lcor}}.
}
\examples{
Sigma <- matrix(c(1,0.1,0.1,1), ncol=2)
R <- chol(Sigma)
n <- 1000
x <- matrix(rnorm(n*2), n)
nu <- 8
y <- x / sqrt(rchisq(n, nu)/nu) #multivariate t
cor(y[,1], y[,2])
lcor.comp(y, type = "linear")

x <- matrix(rnorm(n*2), n)
nu <- 2
y <- x / sqrt(rchisq(n, nu)/nu) #multivariate t
cor(y[,1], y[,2], method = "spearman")
lcor.comp(y, type = "rank", plot = TRUE)


}
\references{
Holzmann, Klar (2024). "Lancester correlation - a new dependence measure linked to maximum correlation". \doi{https://doi.org/10.1111/sjos.12733}
}
\seealso{
\code{\link{lcor}, \link{lcor.comp}, \link{lcor.test}}
}
\author{
Hajo Holzmann, Bernhard Klar
}
