% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/header.R
\name{custom_header}
\alias{custom_header}
\title{Custom Header: Customized for Shiny's Header}
\usage{
custom_header(
  title = "MyLareShiny",
  site = NULL,
  favicon = NULL,
  font = "Montserrat",
  logosrc = NULL,
  logo_height = "40px",
  logo_width = NULL,
  loadingsrc = NULL,
  load_height = "40px",
  load_width = NULL,
  text = Sys.Date(),
  type = 1
)
}
\arguments{
\item{title}{Character. Your 'shiny' app title (displayed in Navigators' tab)}

\item{site}{Character. URL for your site (opens when logo is clicked)}

\item{favicon}{Character. Image for your favicon.
Save file in \code{www} directory.}

\item{font}{Character. Font for whole 'shiny' app. Use Google Fonts names.}

\item{logosrc, loadingsrc}{Character. Logo image and loading image. For
local files, save them in \code{www} directory to call them directly.}

\item{logo_height, logo_width, load_height, load_width}{Integer.
Logo and loading images dimensions.}

\item{text}{Character. Text displayed in top right corner.}

\item{type}{Integer. 1 for complete \code{dashboardHeader} results,
2 for title results.}
}
\value{
A dashboardHeader object.
}
\description{
This function personalizes your Shiny dashboard's header with logo,
links, favicon, font, and texts.
}
\examples{
if (interactive()) {
  shinyApp(
    ui = dashboardPage(
      custom_header(
        title = "MyLareShiny",
        site = "https://github.com/laresbernardo/lareshiny",
        font = "Montserrat",
        logosrc = "logo.png",
        text = Sys.Date()
      ),
      dashboardSidebar(disable = TRUE),
      dashboardBody()
    ),
    server = function(input, output) { }
  )
}
}
