% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obtain_zipfs_parameters.R
\name{obtain_zipfs_parameters}
\alias{obtain_zipfs_parameters}
\title{Obtain Zipf's Distribution Parameters from Data}
\usage{
obtain_zipfs_parameters(data)
}
\arguments{
\item{data}{Numeric vector, matrix, or data frame.
Numeric data to determine Zipf's distribution parameters}
}
\value{
Returns a vector containing the estimated \code{beta} and
\code{alpha} parameters. Also contains \code{zipfs_sse} which corresponds
to the sum of square error between frequencies based
on the parameter values estimated and the original data frequencies
}
\description{
Zipf's distribution is commonly found for text data. Closely related to the
Pareto and power-law distributions, the Zipf's distribution produces
highly skewed data. This function obtains the best fitting parameters
to Zipf's distribution
}
\details{
The best parameters are optimized by minimizing the aboslute
difference between the original frequencies and the frequencies obtained
by the \emph{beta} and \emph{alpha} parameters in the following
formula (Piantadosi, 2014):

\emph{f(r) proportional to 1 / (r + beta)^alpha}

where \emph{f(r)} is the \emph{r}th most frequency,
\emph{r} is the rank-order of the data, \emph{beta}
is a shift in the rank (following Mandelbrot, 1953, 1962),
and \emph{alpha} is the power of the rank with greater
values suggesting greater differences between the largest
frequency to the next, and so forth.
}
\examples{
# Generate factor data
two_factor <- simulate_factors(
  factors = 2, # factors = 2
  variables = 6, # variables per factor = 6
  loadings = 0.55, # loadings between = 0.45 to 0.65
  cross_loadings = 0.05, # cross-loadings N(0, 0.05)
  correlations = 0.30, # correlation between factors = 0.30
  sample_size = 1000 # number of cases = 1000
)

# Transform data to Mandelbrot's Zipf's
two_factor_zipfs <- data_to_zipfs(
  lf_object = two_factor,
  beta = 2.7,
  alpha = 1
)

# Obtain Zipf's distribution parameters
obtain_zipfs_parameters(two_factor_zipfs$data)

}
\references{
Mandelbrot, B. (1953).
An informational theory of the statistical structure of language.
\emph{Communication Theory}, \emph{84}, 486–502.

Mandelbrot, B. (1962).
On the theory of word frequencies and on related Markovian models of discourse.
\emph{Structure of Language and its Mathematical Aspects}, 190–219.

Piantadosi, S. T. (2014).
Zipf’s word frequency law in natural language: A critical review and future directions.
\emph{Psychonomic Bulletin & Review}, \emph{21}(5), 1112-1130.
}
\author{
Alexander P. Christensen <alexpaulchristensen@gmail.com>,
Hudson Golino <hfg9s@virginia.edu>,
Luis Eduardo Garrido <luisgarrido@pucmm.edu>
}
