% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmm.fixed.R
\name{latentcov-ergmTerm}
\alias{latentcov-ergmTerm}
\alias{InitErgmTerm.latentcov}
\title{Edge covariates for the latent model}
\usage{
# binary: latentcov(x, attrname=NULL, mean=0, var=9)

# valued: latentcov(x, attrname=NULL, mean=0, var=9)
}
\arguments{
\item{x, attrname}{a specification for the dyadic covariate: either
one of the following, or the name of a network attribute
containing one of the following: \describe{

\item{a covariate matrix}{with dimensions \eqn{n \times n}{n*n}
for unipartite networks and \eqn{b \times (n-b)}{b*(n-b)} for
bipartite networks; \code{attrname}, if given, is used to construct
the term name.}

\item{a network object}{with the same size and bipartitedness as
LHS; \code{attrname}, if given, provides the name of the
quantitative edge attribute to use for covariate values (in
this case, missing edges in \code{x} are assigned a covariate value
of zero).}

}}

\item{mean, var}{prior mean and variance.}
}
\description{
This term adds one statistic to the model, providing a covariate for each dyad.

\code{latentcov} can be called more than once, to model the
effects of multiple covariates. Note that some covariates can be
more conveniently specified using other terms.

\strong{Important:} This term works in \CRANpkg{latentnet}'s \code{\link[=ergmm]{ergmm()}} only. Using it in \code{\link[ergm:ergm]{ergm()}} will result in an error.

It is recommended to only use this term if your network contains self-loops. Otherwise, use the \CRANpkg{ergm} term(s) \Sexpr[results=rd,stage=build]{statnet.common::paste.and(paste0("\\\\ergmTerm{ergm}{", strsplit("edgecov", " ")[[1]], "}{()}"), con = "or")}.
}
\seealso{
\code{\link[ergm:ergmTerm]{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "latentcov", "subsection")}
}
\concept{directed}
\concept{dyad-independent}
\concept{latent}
\concept{undirected}
