% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/natural_key.R
\name{natural_key}
\alias{natural_key}
\title{Create SQL string for joining on matching natural keys}
\usage{
natural_key(table_names, key_columns)
}
\arguments{
\item{table_names}{[character(2)]\cr
Name of data base tables to be joined.}

\item{key_columns}{[character(1:Inf)]\cr
Names of key columns in both tables.}
}
\value{
Character string to be used in SQL statement.
}
\description{
Create string with SQL expressions for \code{WHERE} clause
 to join two tables on the given columns.
}
\details{
The names of tables and key columns must be valid SQL identifiers.
 They are validated to conform to
 the regular expression returned by \code{\link{valid_identifier_regex}}.

 The SQL string is created in 3 steps:
 \enumerate{
   \item Combine table names with key names, eg, "\code{PRL.FLIGHT_NR}".
   \item Create logical expressions, eg, "\code{PRL.FLIGHT_NR = PRL_SSR.FLIGHT_NR}"
   \item Concatenate logical expressions by \code{"and"} to form final SQL esxpression.
 }
}
\note{
The current implementation assumes that key columns have the same names in both tables.
}
\examples{
# SQL expression
(sql_expr <- lazysql::natural_key(c("TAB1", "tab_2"),c("COL1", "col_2")))

# sample SQL JOIN statement
paste("select * from TAB1, TAB2 where", sql_expr)

}
\author{
Uwe Block
}
\seealso{
\code{\link{valid_identifier_regex}}.
}

