% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{lad.voxels}
\alias{lad.voxels}
\title{Creates a data frame of the 3D voxels information (xyz)
with Leaf Area Density values from las file}
\usage{
lad.voxels(normlas.file, grain.size = 1, k = 1)
}
\arguments{
\item{normlas.file}{normalized las file}

\item{grain.size}{horizontal resolution (suggested 1 meter for lad profiles and 10 meters for LAI maps)}

\item{k}{coefficient to transform effective LAI to real LAI (k = 1; for effective LAI)}
}
\value{
A \code{\link[base:data.frame]{data.frame}} of the 3D voxels information (xyz) with Leaf Area Density values
}
\description{
Creates a data frame of the 3D voxels information (xyz)
with Leaf Area Density values from las file
}
\note{
The values of LAD are not estimated below 1 meter. For the following reasons:
ground points influence
realtive low sampling
}
\examples{
# Get the example laz file
normlas.file = system.file("extdata", "lidar_example.laz", package="leafR")

VOXELS_LAD = lad.voxels(normlas.file,
                        grain.size = 2, k=1)

}
