% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addRasterRGB.R
\name{addRasterRGB}
\alias{addRasterRGB}
\alias{addStarsRGB}
\title{Add an RGB image as a layer}
\usage{
addRasterRGB(
  map,
  x,
  r = 3,
  g = 2,
  b = 1,
  quantiles = c(0, 1),
  domain = NULL,
  na.color = "#BEBEBE80",
  method = c("auto", "bilinear", "near", "average", "mode", "cubic", "cubicspline",
    "lanczos", "sum", "min", "q1", "median", "q3", "max", "rms"),
  ...
)

addStarsRGB(
  map,
  x,
  r = 3,
  g = 2,
  b = 1,
  quantiles = c(0, 1),
  domain = NULL,
  na.color = "#BEBEBE80",
  method = c("auto", "bilinear", "near", "average", "mode", "cubic", "cubicspline",
    "lanczos", "sum", "min", "q1", "median", "q3", "max", "rms"),
  ...
)
}
\arguments{
\item{map}{a map widget object created from `leaflet()``}

\item{x}{a  \code{RasterBrick}, \code{RasterStack} or `stars`` raster object}

\item{r}{integer. Index of the Red channel/band, between 1 and nlayers(x)}

\item{g}{integer. Index of the Green channel/band, between 1 and nlayers(x)}

\item{b}{integer. Index of the Blue channel/band, between 1 and nlayers(x)}

\item{quantiles}{the upper and lower quantiles used for color stretching.
If set to NULL, stretching is performed basing on \code{domain} argument.}

\item{domain}{the upper and lower values used for color stretching.
This is used only if \code{quantiles} is NULL.
If both \code{domain} and \code{quantiles} are set to NULL, stretching is applied
based on min-max values.}

\item{na.color}{the color to be used for NA pixels}

\item{method}{character. Method used for estimating the new cell values of a SpatRaster. One of: 
  
	\code{bilinear}: bilinear interpolation (3x3 cell window). This is used by default if the first layer of \code{x} is not categorical

	\code{average}:  This can be a good choice with continuous variables if the output cells overlap with multiple input cells. 

	\code{near}: nearest neighbor. This is used by default if the first layer of \code{x} is categorical. This method is not a good choice for continuous values.

	\code{mode}: The modal value. This can be a good choice for categrical rasters, if the output cells overlap with multiple input cells. 
  
	\code{cubic}: cubic interpolation (5x5 cell window).

	\code{cubicspline}: cubic B-spline interpolation. (5x5 cell window).

	\code{lanczos}: Lanczos windowed sinc resampling. (7x7 cell window).

	\code{sum}: the weighted sum of all non-NA contributing grid cells.

	\code{min, q1, median, q3, max}: the minimum, first quartile, median, third quartile, or maximum value. 
	
	\code{rms}: the root-mean-square value of all non-NA contributing grid cells.
  }

\item{...}{additional arguments passed on to \code{\link[leaflet]{addRasterImage}}}
}
\description{
Create a Red-Green-Blue image overlay from a \code{RasterStack} /
\code{RasterBrick} or \code{stars} object based on three layers.
Three layers (sometimes referred to as "bands" because they may represent
different bandwidths in the electromagnetic spectrum) are combined such
that they represent the red, green and blue channel. This function can
be used to make 'true (or false) color images' from Landsat and other
multi-band satellite images. Note, this text is plagiarized, i.e. copied
from \code{\link[raster]{plotRGB}}.
\code{addRasterRGB} and \code{addStarsRGB} are aliases.
}
\details{
Note, method \code{auto}, the default, will choose between \code{near} for factorial and
\code{bilinear} for numeric data. All other methods need to be set manually.
}
\examples{
\donttest{
  require(raster)
  require(stars)
  require(plainview)
  require(leaflet)

  leaflet() \%>\%
    addTiles(group = "OpenStreetMap") \%>\%
    addRasterRGB(plainview::poppendorf, 4,3,2, group = "True colours") \%>\%
    addStarsRGB(st_as_stars(plainview::poppendorf), 5,4,3, group = "False colours") \%>\%
    addLayersControl(
      baseGroups = c("Satellite"),
      overlayGroups = c("True colours", "False colours"),
    )
}

}
\author{
Tim Appelhans, Luigi Ranghetti
}
