% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spin.R
\name{addSpinner}
\alias{addSpinner}
\alias{startSpinner}
\alias{stopSpinner}
\title{Add Spin Plugin}
\usage{
addSpinner(map)

startSpinner(map, options = NULL)

stopSpinner(map)
}
\arguments{
\item{map}{A map widget object created from \code{\link[leaflet]{leaflet}}}

\item{options}{Spin.js options. Named list. See \url{http://spin.js.org}}
}
\value{
A leaflet map object
}
\description{
Adds an animated loading spinning over the map.
}
\examples{
library(leaflet)
library(leaflet.extras2)

leaflet(data = quakes) \%>\%
  addTiles() \%>\%
  addSpinner() \%>\%
  startSpinner(options = list("lines" = 7, "length" = 20)) \%>\%
  addMarkers(~long, ~lat, popup = ~ as.character(mag), label = ~ as.character(mag)) \%>\%
  stopSpinner()
}
\references{
\url{https://github.com/makinacorpus/Leaflet.Spin}

\url{https://github.com/fgnass/spin.js}
}
