% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{run_detectors}
\alias{run_detectors}
\title{Run multiple detectors on audit data}
\usage{
run_detectors(detectors, audit_data, config)
}
\arguments{
\item{detectors}{A list of detector configurations. Each detector can be either a function
or an object that contains a \code{func} field with the detector function.}

\item{audit_data}{A data.frame, tibble, or data.table to audit.}

\item{config}{A list of configuration settings to be passed to each detector.}
}
\value{
A list where each element contains the results of running a detector. If a detector
fails, an error message is included in the result.
}
\description{
This function runs multiple leakage detectors on the provided audit data and
returns the results for each detector.
}
\examples{
\dontrun{
detectors <- list(
  temporal = list(func = temporal_detector_func),
  train_test = new_train_test_detector()
)
results <- run_detectors(detectors, audit_data = iris, config = list(sample_size = 50000))
}

}
\keyword{internal}
