% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probability.R
\name{P}
\alias{P}
\title{Cumulative distribution function}
\usage{
P(
  q,
  dist = "normal",
  lower.tail = TRUE,
  rounding = 5,
  porcentage = FALSE,
  gui = "plot",
  main = NULL,
  ...
)
}
\arguments{
\item{q}{quantile. The \code{q} argument can have length 1 or 2. See Details.}

\item{dist}{distribution to use. The default is \code{'normal'}. Options: \code{'normal'}, \code{'t-student'}, \code{'gumbel'}, \code{'binomial'}, \code{'poisson'}, and ....}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are \eqn{P[X \leq x]} otherwise, \eqn{P[X > x]}. This argument is valid only if \code{q} has length 1.}

\item{rounding}{numerical; it represents the number of decimals for calculating the probability.}

\item{porcentage}{logical; if \code{FALSE} (default), the result in decimal. Otherwise, probability is given in percentage.}

\item{gui}{default is \code{'plot'}; it graphically displays the result of the probability. Others options are: \code{'none'}, \code{'rstudio'} or \code{'tcltk'}.}

\item{main}{defalt is \code{NULL}; it represents title of plot.}

\item{...}{additional arguments according to the chosen distribution.}
}
\value{
\code{P} returns the probability and its graphical representation. The result can be given as a percentage or not.
}
\description{
\code{P} Compute the cumulative distribution function for multiple distributions
}
\details{
The argument that can have length 2, when we use the functions that give us the probability regions, given by: \code{\%<X<\%}, \code{\%<=X<\%}, \code{\%<X<=\%}, \code{\%<=X<=\%}, \code{\%>X>\%}, \code{\%>X=>\%}, \code{\%>X=>\%} and \code{\%>=X=>\%}.
The additional arguments represent the parameters of the distributions, that is:
}
\examples{
# Loading package
library(leem)
# Example 1 - t-Student distribution
\dontrun{
P(q = 2, dist = "t-student", df = 10)
P(q = 2, dist = "t-student", df = 10, gui = 'rstudio')
P(q = 2, dist = "t-student", df = 10, gui = 'tcltk')
P(-1 \%<X<\% 1, dist = "t-student", df = 10)
}
# Example 2 - Normal distribution
P(-2,  dist = "normal", mean = 3, sd = 2,
  main = expression(f(x) == (1 / sqrt(n * sigma^2)) *
  exp(-1/2 * (x - mu)^2/sigma^2)))
}
