% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidytuesday.R
\name{tidytuesday}
\alias{tidytuesday}
\title{Create a new folder for \emph{#tidytuesday} challenge}
\usage{
tidytuesday(year, week)
}
\arguments{
\item{year}{An integer representing the year of the \emph{#tidytuesday} challenge}

\item{week}{An integer representing the week of interest, from 1 to 52}
}
\value{
A folder containing folders and files for \emph{#tidytuesday} challenge.
}
\description{
This function sets up a new folder for
\emph{\href{https://github.com/rfordatascience/tidytuesday}{#tidytuesday}} challenge
within an \strong{active project}.
It creates a directory for the specified year and week,
along with sub-directories for data, code, and plots.
Template files are also added.
}
\details{
The folder includes:
\itemize{
\item \strong{README.md}: plots for \emph{#tidytuesday} challenge
\item different folders to hold all \emph{data}, \emph{code}, \emph{plots} of data analysis
\item templates
}
}
\note{
Ensure that this function is called within an \strong{active project}.
}
\examples{
\donttest{

if(interactive()){
  tidytuesday(year = 2021, week = 25)
}
}
}
