% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.lemna_result}
\alias{plot.lemna_result}
\title{Plot a Lemna scenario result}
\usage{
\method{plot}{lemna_result}(x, y, munit = "ug/m2", cunit = "ug/L", legend = TRUE, ...)
}
\arguments{
\item{x}{\code{lemna_result} object}

\item{y}{unused parameter}

\item{munit}{character, unit of internal mass, defaults to \code{ug/m2}}

\item{cunit}{character, unit of exposure, defaults to \code{ug/L}}

\item{legend}{logical, if \code{TRUE} then a legend is displayed, set to \code{FALSE}
to hide legend, defaults to \code{TRUE}}

\item{...}{unused parameter}
}
\value{
a gridded plot
}
\description{
Creates up to four plots in a gridded layout depicting
\enumerate{
\item Exposure (i.e. external) concentration, as well as damage (internal concentration, \code{C_int})
if available
\item Internal toxicant mass (\code{M_int})
\item Population size as biomass (\code{BM})
\item Population size as number of fronds (\code{FrondNo}) if available
}
}
\examples{
# Simulate a sample scenario and plot results
result <- lemna(metsulfuron)
plot(result)

# Hide the legend of the concentration plot
plot(result, legend=FALSE)

# Simulate and plot a scenario with changing environmental conditions
plot(lemna(focusd1))
}
