% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verbs.R
\name{over}
\alias{over}
\title{Map a function over a lens}
\usage{
over(d, l, f)
}
\arguments{
\item{d}{the data (or an \link{oscope})}

\item{l}{the lens (or the function if \code{d} is an \code{oscope})}

\item{f}{the function (or nothing if \code{d} is an \code{oscope})}
}
\description{
Get the data pointed to by a lens, apply a function
and replace it with the result.
}
\examples{
third_l <- index(3)
over(1:5, third_l, function(x) x + 2)
# returns c(1:2, 5, 4:5)  
}
