% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lepidochroma.R
\name{lepidochroma}
\alias{lepidochroma}
\title{Colour palettes inspired by butterflies}
\usage{
lepidochroma(name, n = NULL)
}
\arguments{
\item{name}{Palette name (see the \code{name} column in the data frame
returned by \code{lepidochroma_palettes()} for a list of available
options).  This argument is case insensitive.}

\item{n}{Number of colours to return.  It is an optional argument:
if it is not specified, all available colours for the specified
palette will be returned.  For continuous palettes (see the
output of \code{lepidochroma_palettes()}) this parameter can take any
number >= 2.  For discrete palettes, its maximum value is limited
to their number of colours.}
}
\value{
A character vector with colours as hexadecimal strings.
}
\description{
Returns a colour palette from the \code{lepidochroma} collection.
}
\examples{
# Discrete palette
lepidochroma("attacus", 4)
# Continuous palette
lepidochroma("morpho", 30)

}
