% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regressors.R
\name{BaseEstimator}
\alias{BaseEstimator}
\title{BaseEstimator}
\value{
R6 Class of BaseEstimator
}
\description{
A dummy base R6 class that provides get_all_fields, get_attributes and set_random_state functionalities for estimators
}
\examples{

## ------------------------------------------------
## Method `BaseEstimator$get_all_fields`
## ------------------------------------------------

TestClass <- R6::R6Class(classname = "TestClass",
inherit = BaseEstimator,
private = list(random_state = NULL))
exampleClass <- TestClass$new()
exampleClass$get_all_fields()

## ------------------------------------------------
## Method `BaseEstimator$get_attributes`
## ------------------------------------------------

exampleClass$get_attributes()

## ------------------------------------------------
## Method `BaseEstimator$set_random_state`
## ------------------------------------------------

exampleClass$set_random_state(2022)
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BaseEstimator-get_all_fields}{\code{BaseEstimator$get_all_fields()}}
\item \href{#method-BaseEstimator-get_attributes}{\code{BaseEstimator$get_attributes()}}
\item \href{#method-BaseEstimator-set_random_state}{\code{BaseEstimator$set_random_state()}}
\item \href{#method-BaseEstimator-clone}{\code{BaseEstimator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseEstimator-get_all_fields"></a>}}
\if{latex}{\out{\hypertarget{method-BaseEstimator-get_all_fields}{}}}
\subsection{Method \code{get_all_fields()}}{
Auxiliary function returning the name of all private and public fields of the self class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseEstimator$get_all_fields()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{TestClass <- R6::R6Class(classname = "TestClass",
inherit = BaseEstimator,
private = list(random_state = NULL))
exampleClass <- TestClass$new()
exampleClass$get_all_fields()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseEstimator-get_attributes"></a>}}
\if{latex}{\out{\hypertarget{method-BaseEstimator-get_attributes}{}}}
\subsection{Method \code{get_attributes()}}{
Auxiliary function returning the name and values of all private and public fields of the self class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseEstimator$get_attributes()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{exampleClass$get_attributes()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseEstimator-set_random_state"></a>}}
\if{latex}{\out{\hypertarget{method-BaseEstimator-set_random_state}{}}}
\subsection{Method \code{set_random_state()}}{
Auxiliary function that sets random state attribute of the self class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseEstimator$set_random_state(random_state)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{random_state}}{seed number to be set as random state}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{exampleClass$set_random_state(2022)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseEstimator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BaseEstimator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseEstimator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
