% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_dots.R
\name{dots1_is_pkglist}
\alias{dots1_is_pkglist}
\title{Is the 1st 'dots' arg a character vector with length > 1?}
\usage{
dots1_is_pkglist(...)
}
\arguments{
\item{...}{(Dots)}
}
\value{
\code{TRUE} if \code{..1} is a vector or list with length > 1.
}
\description{
Is the 1st 'dots' arg a character vector with length > 1?
}
\examples{
\dontrun{
dots1_is_pkglist()

#> [1] FALSE

dots1_is_pkglist("hello", "hey", "hi")

#> [1] FALSE

dots1_is_pkglist(c("hello", "hey"), "hi")

#> [1] TRUE

dots1_is_pkglist(c(hello, hey), "hi")

#> [1] FALSE

# A common programming scenario:
pkg_list <- c("only_one_package")
dots1_is_pkglist(pkg_list)

#> [1] TRUE
}

}
