% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_name.R
\name{lx_color_name}
\alias{lx_color_name}
\title{picking a color by name or hsbk}
\usage{
lx_color_name(
  hue = NULL,
  saturation = NULL,
  brightness = NULL,
  kelvin = NULL,
  color_name = NULL,
  check = TRUE,
  token = lx_get_token()
)
}
\arguments{
\item{hue}{set the hue (0-255)}

\item{saturation}{set the saturation (0-1)}

\item{brightness}{set the brightness (0-1)}

\item{kelvin}{set the color temperature. limits depend on the specific lamp; limits are likely in the range of 2500-9000}

\item{color_name}{a color name (i.e. "red"), hexadecimal color code (i.e. "#FF0000") or output from lx_color() (in 'LIFX' api format (see \url{https://api.developer.lifx.com/docs/colors}). If this parameter is used, other parameters may be ignored.}

\item{check}{if FALSE does not call the API to check if the color is valid}

\item{token}{API token (see ?lx_save_token). If left empty, the token is retrieved from the environmental variable if available. (see \code{\link{lx_save_token}})}
}
\value{
a character string specifying a light color as expected by the 'LIFX' API. Outputs from this function have their own class and printing style, but a pure character string can be used just as well.
}
\description{
picking a color by name or hsbk
}
\examples{

\dontrun{

strong_red <- lx_color_name(hue = 0, saturation = 1, brightness = 1)
lx_color(color_name = strong_red)

dim_green <- lx_color_name(color_name = "#00FF00", saturation = 1, brightness = 0.1)
lx_color(color_name = dim_green)

unsaturated_cyan <- lx_color_name(color_name = "cyan", saturation = 0.3)
lx_color(color_name = unsaturated_cyan)
}

}
