# lightsf - Collection of georeferenced and spatial datasets from different domains
# Version 0.1.0
# Copyright (C) 2025 Ingrid Romero Pinilla
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# baltimore_pts

library(testthat)

# Test 1: Confirm the object is a data.frame
test_that("baltimore_pts is a data.frame", {
  expect_s3_class(baltimore_pts, "data.frame")
})

# Test 2: Confirm it has exactly 17 columns
test_that("baltimore_pts has 17 columns", {
  expect_equal(length(baltimore_pts), 17)
})

# Test 3: Confirm it has exactly 211 rows
test_that("baltimore_pts has 211 rows", {
  expect_equal(nrow(baltimore_pts), 211)
})

# Test 4: Confirm column names are correct
test_that("baltimore_pts has correct column names", {
  expect_named(baltimore_pts, c(
    "STATION", "PRICE", "NROOM", "DWELL", "NBATH", "PATIO",
    "FIREPL", "AC", "BMENT", "NSTOR", "GAR", "AGE",
    "CITCOU", "LOTSZ", "SQFT", "X", "Y"
  ))
})

# Test 5: Confirm column types are as expected
test_that("baltimore_pts columns have correct types", {
  expect_type(baltimore_pts$STATION, "integer")
  expect_type(baltimore_pts$PRICE, "double")
  expect_type(baltimore_pts$NROOM, "double")
  expect_type(baltimore_pts$DWELL, "double")
  expect_type(baltimore_pts$NBATH, "double")
  expect_type(baltimore_pts$PATIO, "double")
  expect_type(baltimore_pts$FIREPL, "double")
  expect_type(baltimore_pts$AC, "double")
  expect_type(baltimore_pts$BMENT, "double")
  expect_type(baltimore_pts$NSTOR, "double")
  expect_type(baltimore_pts$GAR, "double")
  expect_type(baltimore_pts$AGE, "double")
  expect_type(baltimore_pts$CITCOU, "double")
  expect_type(baltimore_pts$LOTSZ, "double")
  expect_type(baltimore_pts$SQFT, "double")
  expect_type(baltimore_pts$X, "double")
  expect_type(baltimore_pts$Y, "double")
})
